/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.client;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.http.RequestExecutor;
import com.okta.commons.lang.Assert;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.client.Client;
import com.okta.sdk.impl.client.BaseClient;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrant;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrantList;
import com.okta.sdk.resource.authorization.server.AuthorizationServer;
import com.okta.sdk.resource.authorization.server.AuthorizationServerList;
import com.okta.sdk.resource.domain.Domain;
import com.okta.sdk.resource.domain.DomainList;
import com.okta.sdk.resource.event.hook.EventHook;
import com.okta.sdk.resource.event.hook.EventHookList;
import com.okta.sdk.resource.feature.Feature;
import com.okta.sdk.resource.feature.FeatureList;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.group.rule.GroupRuleList;
import com.okta.sdk.resource.identity.provider.IdentityProvider;
import com.okta.sdk.resource.identity.provider.IdentityProviderList;
import com.okta.sdk.resource.inline.hook.InlineHook;
import com.okta.sdk.resource.inline.hook.InlineHookList;
import com.okta.sdk.resource.linked.object.LinkedObject;
import com.okta.sdk.resource.linked.object.LinkedObjectList;
import com.okta.sdk.resource.log.LogEventList;
import com.okta.sdk.resource.network.zone.NetworkZone;
import com.okta.sdk.resource.network.zone.NetworkZoneList;
import com.okta.sdk.resource.policy.Policy;
import com.okta.sdk.resource.policy.PolicyList;
import com.okta.sdk.resource.profile.mapping.ProfileMapping;
import com.okta.sdk.resource.profile.mapping.ProfileMappingList;
import com.okta.sdk.resource.role.CatalogApplicationList;
import com.okta.sdk.resource.session.CreateSessionRequest;
import com.okta.sdk.resource.session.Session;
import com.okta.sdk.resource.template.SmsTemplate;
import com.okta.sdk.resource.template.SmsTemplateList;
import com.okta.sdk.resource.template.SmsTemplateType;
import com.okta.sdk.resource.threat.insight.ThreatInsightConfiguration;
import com.okta.sdk.resource.trusted.origin.TrustedOrigin;
import com.okta.sdk.resource.trusted.origin.TrustedOriginList;
import com.okta.sdk.resource.user.CreateUserRequest;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.RoleList;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserList;
import com.okta.sdk.resource.user.UserNextLogin;
import com.okta.sdk.resource.user.factor.VerifyUserFactorResponse;
import com.okta.sdk.resource.user.schema.UserSchema;
import com.okta.sdk.resource.user.type.UserType;
import com.okta.sdk.resource.user.type.UserTypeList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultClient
extends BaseClient
implements Client {
    public DefaultClient(ClientConfiguration clientConfiguration, CacheManager cacheManager) {
        super(clientConfiguration, cacheManager);
    }

    public DefaultClient(ClientConfiguration clientConfiguration, CacheManager cacheManager, RequestExecutor requestExecutor) {
        super(clientConfiguration, cacheManager, requestExecutor);
    }

    public ApplicationList listApplications(String q, String filter, String expand, Boolean includeNonDeleted) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        if (includeNonDeleted != null) {
            queryArgs.put("includeNonDeleted", includeNonDeleted);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps", ApplicationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationList listApplications() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps", ApplicationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Application createApplication(Application application, Boolean activate, String oktaAccessGatewayAgent) {
        Assert.notNull((Object)application, (String)"'application' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        HttpHeaders headers = new HttpHeaders();
        if (oktaAccessGatewayAgent != null) {
            headers.add("OktaAccessGateway-Agent", oktaAccessGatewayAgent);
        }
        this.getDataStore().create("/api/v1/apps", application, null, Application.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return application;
    }

    public Application createApplication(Application application) {
        Assert.notNull((Object)application, (String)"'application' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps", application, null, Application.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return application;
    }

    public Application getApplication(String appId, String expand) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "", Application.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Application getApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "", Application.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerList listAuthorizationServers(String q) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers", AuthorizationServerList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerList listAuthorizationServers() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers", AuthorizationServerList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServer createAuthorizationServer(AuthorizationServer authorizationServer) {
        Assert.notNull((Object)authorizationServer, (String)"'authorizationServer' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers", authorizationServer, null, AuthorizationServer.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return authorizationServer;
    }

    public AuthorizationServer getAuthorizationServer(String authServerId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "", AuthorizationServer.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public DomainList listDomains() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/domains", DomainList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Domain createDomain(Domain domain) {
        Assert.notNull((Object)domain, (String)"'domain' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/domains", domain, null, Domain.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return domain;
    }

    public void deleteDomain(String domainId) {
        Assert.hasText((String)domainId, (String)"'domainId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/domains/" + domainId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public Domain getDomain(String domainId) {
        Assert.hasText((String)domainId, (String)"'domainId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/domains/" + domainId + "", Domain.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Domain verifyDomain(String domainId) {
        Assert.hasText((String)domainId, (String)"'domainId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/domains/" + domainId + "/verify", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, Domain.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public EventHookList listEventHooks() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/eventHooks", EventHookList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public EventHook createEventHook(EventHook eventHook) {
        Assert.notNull((Object)eventHook, (String)"'eventHook' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/eventHooks", eventHook, null, EventHook.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return eventHook;
    }

    public EventHook getEventHook(String eventHookId) {
        Assert.hasText((String)eventHookId, (String)"'eventHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/eventHooks/" + eventHookId + "", EventHook.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public FeatureList listFeatures() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/features", FeatureList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Feature getFeature(String featureId) {
        Assert.hasText((String)featureId, (String)"'featureId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/features/" + featureId + "", Feature.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listGroups(String q, String search, String expand) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (search != null) {
            queryArgs.put("search", search);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listGroups() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Group createGroup(Group group) {
        Assert.notNull((Object)group, (String)"'group' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/groups", group, null, Group.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return group;
    }

    public GroupRuleList listGroupRules(String search, String expand) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (search != null) {
            queryArgs.put("search", search);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/rules", GroupRuleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupRuleList listGroupRules() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/rules", GroupRuleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupRule createGroupRule(GroupRule groupRule) {
        Assert.notNull((Object)groupRule, (String)"'groupRule' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/groups/rules", groupRule, null, GroupRule.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return groupRule;
    }

    public GroupRule getGroupRule(String ruleId, String expand) {
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/rules/" + ruleId + "", GroupRule.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupRule getGroupRule(String ruleId) {
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/rules/" + ruleId + "", GroupRule.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Group getGroup(String groupId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "", Group.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public RoleList listGroupAssignedRoles(String groupId, String expand) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/roles", RoleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public RoleList listGroupAssignedRoles(String groupId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/roles", RoleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeRoleFromGroup(String groupId, String roleId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/" + groupId + "/roles/" + roleId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public Role getRole(String groupId, String roleId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/roles/" + roleId + "", Role.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public CatalogApplicationList listApplicationTargetsForApplicationAdministratorRoleForGroup(String groupId, String roleId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps", CatalogApplicationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeApplicationTargetFromApplicationAdministratorRoleGivenToGroup(String groupId, String roleId, String appName) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeApplicationTargetFromAdministratorRoleGivenToGroup(String groupId, String roleId, String appName, String applicationId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        Assert.hasText((String)applicationId, (String)"'applicationId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "/" + applicationId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listGroupTargetsForGroupRole(String groupId, String roleId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeGroupTargetFromGroupAdministratorRoleGivenToGroup(String groupId, String roleId, String targetGroupId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)targetGroupId, (String)"'targetGroupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/groups/" + targetGroupId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProviderList listIdentityProviders(String q, String type) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (type != null) {
            queryArgs.put("type", type);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps", IdentityProviderList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProviderList listIdentityProviders() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps", IdentityProviderList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProvider createIdentityProvider(IdentityProvider identityProvider) {
        Assert.notNull((Object)identityProvider, (String)"'identityProvider' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/idps", identityProvider, null, IdentityProvider.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return identityProvider;
    }

    public JsonWebKeyList listIdentityProviderKeys() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/credentials/keys", JsonWebKeyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey createIdentityProviderKey(JsonWebKey jsonWebKey) {
        Assert.notNull((Object)jsonWebKey, (String)"'jsonWebKey' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/idps/credentials/keys", jsonWebKey, null, JsonWebKey.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return jsonWebKey;
    }

    public void deleteIdentityProviderKey(String keyId) {
        Assert.hasText((String)keyId, (String)"'keyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/idps/credentials/keys/" + keyId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey getIdentityProviderKey(String keyId) {
        Assert.hasText((String)keyId, (String)"'keyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/credentials/keys/" + keyId + "", JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProvider getIdentityProvider(String idpId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "", IdentityProvider.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey apiV1IdpsIdpIdCredentialsCsrsCsrIdLifecyclePublishPost(String idpId, String csrId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/credentials/csrs/" + csrId + "/lifecycle/publish", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public InlineHookList listInlineHooks(String type) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (type != null) {
            queryArgs.put("type", type);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/inlineHooks", InlineHookList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public InlineHookList listInlineHooks() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/inlineHooks", InlineHookList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public InlineHook createInlineHook(InlineHook inlineHook) {
        Assert.notNull((Object)inlineHook, (String)"'inlineHook' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/inlineHooks", inlineHook, null, InlineHook.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return inlineHook;
    }

    public InlineHook getInlineHook(String inlineHookId) {
        Assert.hasText((String)inlineHookId, (String)"'inlineHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/inlineHooks/" + inlineHookId + "", InlineHook.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public LogEventList getLogs(Date since, Date until, String filter, String q, String sortOrder) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (since != null) {
            queryArgs.put("since", since);
        }
        if (until != null) {
            queryArgs.put("until", until);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (sortOrder != null) {
            queryArgs.put("sortOrder", sortOrder);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/logs", LogEventList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public LogEventList getLogs() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/logs", LogEventList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ProfileMappingList listProfileMappings(String sourceId, String targetId) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sourceId != null) {
            queryArgs.put("sourceId", sourceId);
        }
        if (targetId != null) {
            queryArgs.put("targetId", targetId);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/mappings", ProfileMappingList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ProfileMappingList listProfileMappings() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/mappings", ProfileMappingList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ProfileMapping getProfileMapping(String mappingId) {
        Assert.hasText((String)mappingId, (String)"'mappingId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/mappings/" + mappingId + "", ProfileMapping.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserSchema getApplicationUserSchema(String appInstanceId) {
        Assert.hasText((String)appInstanceId, (String)"'appInstanceId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/schemas/apps/" + appInstanceId + "/default", UserSchema.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserSchema updateApplicationUserProfile(String appInstanceId, UserSchema body) {
        Assert.hasText((String)appInstanceId, (String)"'appInstanceId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/meta/schemas/apps/" + appInstanceId + "/default", body, null, UserSchema.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public UserSchema updateApplicationUserProfile(String appInstanceId) {
        Assert.hasText((String)appInstanceId, (String)"'appInstanceId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/meta/schemas/apps/" + appInstanceId + "/default", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, UserSchema.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public LinkedObjectList listLinkedObjectDefinitions() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/schemas/user/linkedObjects", LinkedObjectList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public LinkedObject addLinkedObjectDefinition(LinkedObject linkedObject) {
        Assert.notNull((Object)linkedObject, (String)"'linkedObject' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/meta/schemas/user/linkedObjects", linkedObject, null, LinkedObject.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return linkedObject;
    }

    public LinkedObject getLinkedObjectDefinition(String linkedObjectName) {
        Assert.hasText((String)linkedObjectName, (String)"'linkedObjectName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/schemas/user/linkedObjects/" + linkedObjectName + "", LinkedObject.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserSchema getUserSchema(String schemaId) {
        Assert.hasText((String)schemaId, (String)"'schemaId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/schemas/user/" + schemaId + "", UserSchema.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserSchema updateUserProfile(String schemaId, UserSchema userSchema) {
        Assert.notNull((Object)userSchema, (String)"'userSchema' is required and cannot be null.");
        Assert.hasText((String)schemaId, (String)"'schemaId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/meta/schemas/user/" + schemaId + "", userSchema, null, UserSchema.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return userSchema;
    }

    public UserTypeList listUserTypes() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/types/user", UserTypeList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserType createUserType(UserType userType) {
        Assert.notNull((Object)userType, (String)"'userType' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/meta/types/user", userType, null, UserType.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return userType;
    }

    public UserType getUserType(String typeId) {
        Assert.hasText((String)typeId, (String)"'typeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/types/user/" + typeId + "", UserType.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyList listPolicies(String type, String status, String expand) {
        Assert.notNull((Object)type, (String)"'type' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (type != null) {
            queryArgs.put("type", type);
        }
        if (status != null) {
            queryArgs.put("status", status);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies", PolicyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyList listPolicies(String type) {
        Assert.notNull((Object)type, (String)"'type' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        queryArgs.put("type", type);
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies", PolicyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Policy createPolicy(Policy policy, Boolean activate) {
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies", policy, null, Policy.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policy;
    }

    public Policy createPolicy(Policy policy) {
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies", policy, null, Policy.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policy;
    }

    public Policy getPolicy(String policyId, String expand) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies/" + policyId + "", Policy.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Policy getPolicy(String policyId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies/" + policyId + "", Policy.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Session createSession(CreateSessionRequest createSessionRequest) {
        Assert.notNull((Object)createSessionRequest, (String)"'createSessionRequest' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/sessions", createSessionRequest, null, Session.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public Session getSession(String sessionId) {
        Assert.hasText((String)sessionId, (String)"'sessionId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/sessions/" + sessionId + "", Session.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public SmsTemplateList listSmsTemplates(SmsTemplateType templateType) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (templateType != null) {
            queryArgs.put("templateType", templateType);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/templates/sms", SmsTemplateList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public SmsTemplateList listSmsTemplates() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/templates/sms", SmsTemplateList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public SmsTemplate createSmsTemplate(SmsTemplate smsTemplate) {
        Assert.notNull((Object)smsTemplate, (String)"'smsTemplate' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/templates/sms", smsTemplate, null, SmsTemplate.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return smsTemplate;
    }

    public SmsTemplate getSmsTemplate(String templateId) {
        Assert.hasText((String)templateId, (String)"'templateId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/templates/sms/" + templateId + "", SmsTemplate.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ThreatInsightConfiguration getCurrentConfiguration() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/threats/configuration", ThreatInsightConfiguration.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public TrustedOriginList listOrigins(String q, String filter) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/trustedOrigins", TrustedOriginList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public TrustedOriginList listOrigins() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/trustedOrigins", TrustedOriginList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public TrustedOrigin createOrigin(TrustedOrigin trustedOrigin) {
        Assert.notNull((Object)trustedOrigin, (String)"'trustedOrigin' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/trustedOrigins", trustedOrigin, null, TrustedOrigin.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return trustedOrigin;
    }

    public TrustedOrigin getOrigin(String trustedOriginId) {
        Assert.hasText((String)trustedOriginId, (String)"'trustedOriginId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/trustedOrigins/" + trustedOriginId + "", TrustedOrigin.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public TrustedOrigin activateOrigin(String trustedOriginId) {
        Assert.hasText((String)trustedOriginId, (String)"'trustedOriginId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/trustedOrigins/" + trustedOriginId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, TrustedOrigin.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public TrustedOrigin deactivateOrigin(String trustedOriginId) {
        Assert.hasText((String)trustedOriginId, (String)"'trustedOriginId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/trustedOrigins/" + trustedOriginId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, TrustedOrigin.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserList listUsers(String q, String filter, String search, String sortBy, String sortOrder) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (search != null) {
            queryArgs.put("search", search);
        }
        if (sortBy != null) {
            queryArgs.put("sortBy", sortBy);
        }
        if (sortOrder != null) {
            queryArgs.put("sortOrder", sortOrder);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users", UserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserList listUsers() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users", UserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public User createUser(CreateUserRequest body, Boolean activate, Boolean provider, UserNextLogin nextLogin) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        if (provider != null) {
            queryArgs.put("provider", provider);
        }
        if (nextLogin != null) {
            queryArgs.put("nextLogin", nextLogin);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users", body, null, User.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public User createUser(CreateUserRequest body) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users", body, null, User.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public User getUser(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "", User.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public User partialUpdateUser(User user, String userId, Boolean strict) {
        Assert.notNull((Object)user, (String)"'user' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (strict != null) {
            queryArgs.put("strict", strict);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "", user, null, User.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return user;
    }

    public User partialUpdateUser(User user, String userId) {
        Assert.notNull((Object)user, (String)"'user' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "", user, null, User.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return user;
    }

    public OAuth2ScopeConsentGrantList listGrantsForUserAndClient(String userId, String clientId, String expand) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients/" + clientId + "/grants", OAuth2ScopeConsentGrantList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrantList listGrantsForUserAndClient(String userId, String clientId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients/" + clientId + "/grants", OAuth2ScopeConsentGrantList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public VerifyUserFactorResponse getFactorTransactionStatus(String userId, String factorId, String transactionId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        Assert.hasText((String)transactionId, (String)"'transactionId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors/" + factorId + "/transactions/" + transactionId + "", VerifyUserFactorResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrant getUserGrant(String userId, String grantId, String expand) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)grantId, (String)"'grantId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/grants/" + grantId + "", OAuth2ScopeConsentGrant.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrant getUserGrant(String userId, String grantId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)grantId, (String)"'grantId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/grants/" + grantId + "", OAuth2ScopeConsentGrant.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public CatalogApplicationList listApplicationTargetsForApplicationAdministratorRoleForUser(String userId, String roleId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps", CatalogApplicationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeApplicationTargetFromApplicationAdministratorRoleForUser(String userId, String roleId, String appName) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeApplicationTargetFromAdministratorRoleForUser(String userId, String roleId, String appName, String applicationId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        Assert.hasText((String)applicationId, (String)"'applicationId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "/" + applicationId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public NetworkZoneList listNetworkZones(String filter) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/zones", NetworkZoneList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public NetworkZoneList listNetworkZones() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/zones", NetworkZoneList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public NetworkZone createNetworkZone(NetworkZone zone) {
        Assert.notNull((Object)zone, (String)"'zone' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/zones", zone, null, NetworkZone.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return zone;
    }

    public NetworkZone getNetworkZone(String zoneId) {
        Assert.hasText((String)zoneId, (String)"'zoneId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/zones/" + zoneId + "", NetworkZone.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

