/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Strings;
import com.okta.sdk.client.Client;
import com.okta.sdk.impl.resource.DefaultApplicationBuilder;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationAccessibility;
import com.okta.sdk.resource.application.ApplicationCredentialsOAuthClient;
import com.okta.sdk.resource.application.ApplicationVisibility;
import com.okta.sdk.resource.application.ApplicationVisibilityHide;
import com.okta.sdk.resource.application.OAuthApplicationCredentials;
import com.okta.sdk.resource.application.OAuthEndpointAuthenticationMethod;
import com.okta.sdk.resource.application.OAuthGrantType;
import com.okta.sdk.resource.application.OAuthResponseType;
import com.okta.sdk.resource.application.OIdCApplicationBuilder;
import com.okta.sdk.resource.application.OpenIdConnectApplication;
import com.okta.sdk.resource.application.OpenIdConnectApplicationConsentMethod;
import com.okta.sdk.resource.application.OpenIdConnectApplicationSettings;
import com.okta.sdk.resource.application.OpenIdConnectApplicationSettingsClient;
import com.okta.sdk.resource.application.OpenIdConnectApplicationType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultOIdCApplicationBuilder
extends DefaultApplicationBuilder<OIdCApplicationBuilder>
implements OIdCApplicationBuilder {
    private OpenIdConnectApplicationType applicationType;
    private String clientUri;
    private OpenIdConnectApplicationConsentMethod consentMethod;
    private List<OAuthGrantType> grantTypes = new ArrayList<OAuthGrantType>();
    private String logoUri;
    private String policyUri;
    private List<String> redirectUris = new ArrayList<String>();
    private List<OAuthResponseType> responseTypes = new ArrayList<OAuthResponseType>();
    private String tosUri;
    private String clientId;
    private String clientSecret;
    private Boolean autoKeyRotation;
    private OAuthEndpointAuthenticationMethod tokenEndpointAuthMethod;

    public OIdCApplicationBuilder setApplicationType(OpenIdConnectApplicationType applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    public OIdCApplicationBuilder setClientUri(String clientUri) {
        this.clientUri = clientUri;
        return this;
    }

    public OIdCApplicationBuilder setConsentMethod(OpenIdConnectApplicationConsentMethod consentMethod) {
        this.consentMethod = consentMethod;
        return this;
    }

    public OIdCApplicationBuilder setGrantTypes(List<OAuthGrantType> grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public OIdCApplicationBuilder addGrantTypes(OAuthGrantType grantType) {
        this.grantTypes.add(grantType);
        return this;
    }

    public OIdCApplicationBuilder setLogoUri(String logoUri) {
        this.logoUri = logoUri;
        return this;
    }

    public OIdCApplicationBuilder setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
        return this;
    }

    public OIdCApplicationBuilder setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public OIdCApplicationBuilder addRedirectUris(String redirectUri) {
        this.redirectUris.add(redirectUri);
        return this;
    }

    public OIdCApplicationBuilder setResponseTypes(List<OAuthResponseType> responseTypes) {
        this.responseTypes = responseTypes;
        return this;
    }

    public OIdCApplicationBuilder addResponseTypes(OAuthResponseType responseType) {
        this.responseTypes.add(responseType);
        return this;
    }

    public OIdCApplicationBuilder setTosUri(String tosUri) {
        this.tosUri = tosUri;
        return this;
    }

    public OIdCApplicationBuilder setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public OIdCApplicationBuilder setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public OIdCApplicationBuilder setAutoKeyRotation(Boolean autoKeyRotation) {
        this.autoKeyRotation = autoKeyRotation;
        return this;
    }

    public OIdCApplicationBuilder setTokenEndpointAuthMethod(OAuthEndpointAuthenticationMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
        return this;
    }

    public OpenIdConnectApplication buildAndCreate(Client client) {
        return (OpenIdConnectApplication)client.createApplication(this.build(client));
    }

    private Application build(Client client) {
        OpenIdConnectApplication application = (OpenIdConnectApplication)client.instantiate(OpenIdConnectApplication.class);
        if (Strings.hasText((String)this.label)) {
            application.setLabel(this.label);
        }
        if (Objects.nonNull(this.signOnMode)) {
            application.setSignOnMode(this.signOnMode);
        }
        application.setAccessibility((ApplicationAccessibility)client.instantiate(ApplicationAccessibility.class));
        ApplicationAccessibility applicationAccessibility = application.getAccessibility();
        if (Strings.hasText((String)this.loginRedirectUrl)) {
            applicationAccessibility.setLoginRedirectUrl(this.loginRedirectUrl);
        }
        if (Strings.hasText((String)this.errorRedirectUrl)) {
            applicationAccessibility.setErrorRedirectUrl(this.errorRedirectUrl);
        }
        if (Objects.nonNull(this.selfService)) {
            applicationAccessibility.setSelfService(this.selfService);
        }
        application.setVisibility((ApplicationVisibility)client.instantiate(ApplicationVisibility.class));
        ApplicationVisibility applicationVisibility = application.getVisibility();
        ApplicationVisibilityHide applicationVisibilityHide = (ApplicationVisibilityHide)client.instantiate(ApplicationVisibilityHide.class);
        if (Objects.nonNull(this.iOS)) {
            applicationVisibility.setHide(applicationVisibilityHide.setIOS(this.iOS));
        }
        if (Objects.nonNull(this.web)) {
            applicationVisibility.setHide(applicationVisibilityHide.setWeb(this.web));
        }
        application.setSettings((OpenIdConnectApplicationSettings)client.instantiate(OpenIdConnectApplicationSettings.class));
        OpenIdConnectApplicationSettings openIdConnectApplicationSettings = application.getSettings();
        OpenIdConnectApplicationSettingsClient openIdConnectApplicationSettingsClient = (OpenIdConnectApplicationSettingsClient)client.instantiate(OpenIdConnectApplicationSettingsClient.class);
        if (Strings.hasText((String)this.clientUri)) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setClientUri(this.clientUri));
        }
        if (Strings.hasText((String)this.logoUri)) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setLogoUri(this.logoUri));
        }
        if (Strings.hasText((String)this.policyUri)) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setPolicyUri(this.policyUri));
        }
        if (Strings.hasText((String)this.tosUri)) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setTosUri(this.tosUri));
        }
        if (Objects.nonNull(this.redirectUris)) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setRedirectUris(this.redirectUris));
        }
        if (!Objects.nonNull(this.responseTypes) || this.responseTypes.size() <= 0) {
            throw new IllegalArgumentException("Response Type cannot be null, value should be of type OAuthResponseType");
        }
        openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setResponseTypes(this.responseTypes));
        if (!Objects.nonNull(this.grantTypes) || this.grantTypes.size() <= 0) {
            throw new IllegalArgumentException("Grant Type cannot be null, value should be of type OAuthGrantType");
        }
        openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setGrantTypes(this.grantTypes));
        if (Objects.nonNull(this.consentMethod)) {
            openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setConsentMethod(this.consentMethod));
        }
        if (!Objects.nonNull(this.applicationType)) {
            throw new IllegalArgumentException("Application Type cannot be null, value should be of type OpenIdConnectApplicationType");
        }
        openIdConnectApplicationSettings.setOAuthClient(openIdConnectApplicationSettingsClient.setApplicationType(this.applicationType));
        application.setCredentials((OAuthApplicationCredentials)client.instantiate(OAuthApplicationCredentials.class));
        OAuthApplicationCredentials oAuthApplicationCredentials = application.getCredentials();
        ApplicationCredentialsOAuthClient applicationCredentialsOAuthClient = (ApplicationCredentialsOAuthClient)client.instantiate(ApplicationCredentialsOAuthClient.class);
        if (Strings.hasText((String)this.clientId)) {
            oAuthApplicationCredentials.setOAuthClient(applicationCredentialsOAuthClient.setClientId(this.clientId));
        }
        if (Strings.hasText((String)this.clientSecret)) {
            oAuthApplicationCredentials.setOAuthClient(applicationCredentialsOAuthClient.setClientSecret(this.clientSecret));
        }
        if (Objects.nonNull(this.autoKeyRotation)) {
            oAuthApplicationCredentials.setOAuthClient(applicationCredentialsOAuthClient.setAutoKeyRotation(this.autoKeyRotation));
        }
        if (!Objects.nonNull(this.tokenEndpointAuthMethod)) {
            throw new IllegalArgumentException("Token Endpoint Auth Method cannot be null, value should be of type OAuthEndpointAuthenticationMethod");
        }
        oAuthApplicationCredentials.setOAuthClient(applicationCredentialsOAuthClient.setTokenEndpointAuthMethod(this.tokenEndpointAuthMethod));
        return application;
    }
}

