/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.client.Client;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.resource.user.PasswordCredential;
import com.okta.sdk.resource.user.PasswordCredentialHook;
import com.okta.sdk.resource.user.RecoveryQuestionCredential;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserBuilder;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.UserNextLogin;
import com.okta.sdk.resource.user.UserProfile;
import com.okta.sdk.resource.user.UserType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DefaultUserBuilder
implements UserBuilder {
    private char[] password;
    private String securityQuestion;
    private String securityQuestionAnswer;
    private String email;
    private String login;
    private String secondEmail;
    private String firstName;
    private String lastName;
    private String mobilePhone;
    private Boolean active;
    private Boolean provider;
    private UserType userType;
    private String userTypeId;
    private UserNextLogin nextLogin;
    private Set<String> groupIds = new HashSet<String>();
    private Map<String, Object> passwordHashProperties;
    private String passwordHookImportType;
    private Map<String, Object> customProfileAttributes = new LinkedHashMap<String, Object>();

    public UserBuilder setPassword(char[] password) {
        this.password = Arrays.copyOf(password, password.length);
        return this;
    }

    public UserBuilder usePasswordHookForImport() {
        return this.usePasswordHookForImport("default");
    }

    public UserBuilder usePasswordHookForImport(String type) {
        this.passwordHookImportType = type;
        return this;
    }

    public UserBuilder setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
        return this;
    }

    public UserBuilder setSecurityQuestionAnswer(String answer) {
        this.securityQuestionAnswer = answer;
        return this;
    }

    public UserBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public UserBuilder setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public UserBuilder setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public UserBuilder setLogin(String login) {
        this.login = login;
        return this;
    }

    public UserBuilder setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public UserBuilder setSecondEmail(String secondEmail) {
        this.secondEmail = secondEmail;
        return this;
    }

    public UserBuilder setActive(Boolean active) {
        this.active = active;
        return this;
    }

    public UserBuilder setProvider(Boolean provider) {
        this.provider = provider;
        return this;
    }

    public UserBuilder setType(UserType userType) {
        this.userType = userType;
        return this;
    }

    public UserBuilder setType(String userTypeId) {
        this.userTypeId = userTypeId;
        return this;
    }

    public UserBuilder setProfileProperties(Map<String, Object> profileProperties) {
        this.customProfileAttributes.clear();
        return this.putAllProfileProperties(profileProperties);
    }

    public UserBuilder putAllProfileProperties(Map<String, Object> profileProperties) {
        this.customProfileAttributes.putAll(profileProperties);
        return this;
    }

    public UserBuilder putProfileProperty(String key, Object value) {
        this.customProfileAttributes.put(key, value);
        return this;
    }

    public UserBuilder setGroups(Set<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public UserBuilder addGroup(String groupId) {
        this.groupIds.add(groupId);
        return this;
    }

    public UserBuilder setNextLogin(UserNextLogin nextLogin) {
        this.nextLogin = nextLogin;
        return this;
    }

    private User build(Client client) {
        PasswordCredential passwordCredential;
        User user = (User)client.instantiate(User.class);
        user.setProfile((UserProfile)client.instantiate(UserProfile.class));
        UserProfile userProfile = user.getProfile();
        if (Strings.hasText((String)this.firstName)) {
            userProfile.setFirstName(this.firstName);
        }
        if (Strings.hasText((String)this.lastName)) {
            userProfile.setLastName(this.lastName);
        }
        if (Strings.hasText((String)this.email)) {
            userProfile.setEmail(this.email);
        }
        if (Strings.hasText((String)this.secondEmail)) {
            userProfile.setSecondEmail(this.secondEmail);
        }
        if (Strings.hasText((String)this.mobilePhone)) {
            userProfile.setMobilePhone(this.mobilePhone);
        }
        if (Strings.hasText((String)this.login)) {
            userProfile.setLogin(this.login);
        } else {
            userProfile.setLogin(this.email);
        }
        if (Strings.hasText((String)this.userTypeId)) {
            user.setType(((UserType)client.instantiate(UserType.class)).setId(this.userTypeId));
        } else if (this.userType != null) {
            user.setType(this.userType);
        }
        if (!Collections.isEmpty(this.groupIds)) {
            if (user instanceof AbstractResource) {
                ((AbstractResource)user).setProperty("groupIds", this.groupIds, true);
            } else {
                throw new IllegalArgumentException("'User' is not an instance of 'AbstractResource', so 'groupIds' cannot be set. This would only happen if the implementation of 'User' has been customized.");
            }
        }
        userProfile.putAll(this.customProfileAttributes);
        if (Strings.hasText((String)this.securityQuestion)) {
            RecoveryQuestionCredential question = (RecoveryQuestionCredential)client.instantiate(RecoveryQuestionCredential.class);
            question.setQuestion(this.securityQuestion);
            question.setAnswer(this.securityQuestionAnswer);
            this.createCredentialsIfNeeded(user, client).setRecoveryQuestion(question);
        }
        if (this.password != null && this.password.length > 0) {
            if (this.passwordHashProperties != null) {
                throw new IllegalArgumentException("Cannot specify both password and password hash, use one or the other.");
            }
            passwordCredential = (PasswordCredential)client.instantiate(PasswordCredential.class);
            this.createCredentialsIfNeeded(user, client).setPassword(passwordCredential.setValue(this.password));
        }
        if (this.passwordHashProperties != null) {
            passwordCredential = (PasswordCredential)client.instantiate(PasswordCredential.class);
            passwordCredential.put((Object)"hash", this.passwordHashProperties);
            this.createCredentialsIfNeeded(user, client).setPassword(passwordCredential);
        }
        if (this.passwordHookImportType != null) {
            passwordCredential = (PasswordCredential)client.instantiate(PasswordCredential.class);
            PasswordCredentialHook passwordCredentialHook = (PasswordCredentialHook)client.instantiate(PasswordCredentialHook.class);
            passwordCredentialHook.setType(this.passwordHookImportType);
            passwordCredential.setHook(passwordCredentialHook);
            this.createCredentialsIfNeeded(user, client).setPassword(passwordCredential);
        }
        return user;
    }

    private UserCredentials createCredentialsIfNeeded(User user, Client client) {
        if (user.getCredentials() == null) {
            UserCredentials credentials = (UserCredentials)client.instantiate(UserCredentials.class);
            user.setCredentials(credentials);
        }
        return user.getCredentials();
    }

    public UserBuilder setBcryptPasswordHash(String value, String salt, int workFactor) {
        this.passwordHashProperties = new HashMap<String, Object>();
        this.passwordHashProperties.put("algorithm", "BCRYPT");
        this.passwordHashProperties.put("workFactor", workFactor);
        this.passwordHashProperties.put("salt", salt);
        this.passwordHashProperties.put("value", value);
        return this;
    }

    public UserBuilder setSha256PasswordHash(String value, String salt, String saltOrder) {
        return this.setShaPasswordHash("SHA-256", value, salt, saltOrder);
    }

    public UserBuilder setSha512PasswordHash(String value, String salt, String saltOrder) {
        return this.setShaPasswordHash("SHA-512", value, salt, saltOrder);
    }

    public UserBuilder setSha1PasswordHash(String value, String salt, String saltOrder) {
        return this.setShaPasswordHash("SHA-1", value, salt, saltOrder);
    }

    private UserBuilder setShaPasswordHash(String shaAlgorithm, String value, String salt, String saltOrder) {
        this.passwordHashProperties = new HashMap<String, Object>();
        this.passwordHashProperties.put("algorithm", shaAlgorithm);
        this.passwordHashProperties.put("salt", salt);
        this.passwordHashProperties.put("value", value);
        this.passwordHashProperties.put("saltOrder", saltOrder);
        return this;
    }

    public User buildAndCreate(Client client) {
        return client.createUser(this.build(client), this.active, this.provider, this.nextLogin);
    }
}

