/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.authorization.server;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.application.AuthorizationServerCredentials;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.application.JwkUse;
import com.okta.sdk.resource.application.OAuth2Claim;
import com.okta.sdk.resource.application.OAuth2ClaimList;
import com.okta.sdk.resource.application.OAuth2ClientList;
import com.okta.sdk.resource.application.OAuth2RefreshToken;
import com.okta.sdk.resource.application.OAuth2RefreshTokenList;
import com.okta.sdk.resource.application.OAuth2Scope;
import com.okta.sdk.resource.application.OAuth2ScopeList;
import com.okta.sdk.resource.authorization.server.AuthorizationServer;
import com.okta.sdk.resource.policy.Policy;
import com.okta.sdk.resource.policy.PolicyList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultAuthorizationServer
extends AbstractInstanceResource<AuthorizationServer>
implements AuthorizationServer {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final ListProperty audiencesProperty = new ListProperty("audiences");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final ResourceReference<AuthorizationServerCredentials> credentialsProperty = new ResourceReference<AuthorizationServerCredentials>("credentials", AuthorizationServerCredentials.class, false);
    private static final StringProperty descriptionProperty = new StringProperty("description");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final StringProperty issuerProperty = new StringProperty("issuer");
    private static final EnumProperty<AuthorizationServer.IssuerModeEnum> issuerModeProperty = new EnumProperty<AuthorizationServer.IssuerModeEnum>("issuerMode", AuthorizationServer.IssuerModeEnum.class);
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final EnumProperty<AuthorizationServer.StatusEnum> statusProperty = new EnumProperty<AuthorizationServer.StatusEnum>("status", AuthorizationServer.StatusEnum.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultAuthorizationServer.createPropertyDescriptorMap(linksProperty, audiencesProperty, createdProperty, credentialsProperty, descriptionProperty, idProperty, issuerProperty, issuerModeProperty, lastUpdatedProperty, nameProperty, statusProperty);

    public DefaultAuthorizationServer(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAuthorizationServer(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return AuthorizationServer.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public List<String> getAudiences() {
        return this.getListProperty(audiencesProperty);
    }

    public AuthorizationServer setAudiences(List<String> audiences) {
        this.setProperty(audiencesProperty, audiences);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public AuthorizationServerCredentials getCredentials() {
        return this.getResourceProperty(credentialsProperty);
    }

    public AuthorizationServer setCredentials(AuthorizationServerCredentials credentials) {
        this.setProperty(credentialsProperty, (Object)credentials);
        return this;
    }

    public String getDescription() {
        return this.getString(descriptionProperty);
    }

    public AuthorizationServer setDescription(String description) {
        this.setProperty(descriptionProperty, (Object)description);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public String getIssuer() {
        return this.getString(issuerProperty);
    }

    public AuthorizationServer setIssuer(String issuer) {
        this.setProperty(issuerProperty, (Object)issuer);
        return this;
    }

    public AuthorizationServer.IssuerModeEnum getIssuerMode() {
        return this.getEnumProperty(issuerModeProperty);
    }

    public AuthorizationServer setIssuerMode(AuthorizationServer.IssuerModeEnum issuerMode) {
        this.setProperty(issuerModeProperty, (Object)issuerMode);
        return this;
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public AuthorizationServer setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public AuthorizationServer.StatusEnum getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public AuthorizationServer setStatus(AuthorizationServer.StatusEnum status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public void activate() {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteOAuth2Claim(String claimId) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)claimId, (String)"'claimId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/claims/" + claimId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Scope createOAuth2Scope(OAuth2Scope oAuth2Scope) {
        String authServerId = this.getId();
        Assert.notNull((Object)oAuth2Scope, (String)"'oAuth2Scope' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/scopes", oAuth2Scope, this, OAuth2Scope.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return oAuth2Scope;
    }

    public OAuth2Scope getOAuth2Scope(String scopeId) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)scopeId, (String)"'scopeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/scopes/" + scopeId + "", OAuth2Scope.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Policy createPolicy(Policy policy) {
        String authServerId = this.getId();
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/policies", policy, this, Policy.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policy;
    }

    public PolicyList listPolicies() {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/policies", PolicyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ClaimList listOAuth2Claims() {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/claims", OAuth2ClaimList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Claim getOAuth2Claim(String claimId) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)claimId, (String)"'claimId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/claims/" + claimId + "", OAuth2Claim.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ClientList listOAuth2Clients() {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/clients", OAuth2ClientList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivate() {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteOAuth2Scope(String scopeId) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)scopeId, (String)"'scopeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/scopes/" + scopeId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKeyList listKeys() {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/credentials/keys", JsonWebKeyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeList listOAuth2Scopes(String q, String filter, String cursor) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (cursor != null) {
            queryArgs.put("cursor", cursor);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/scopes", OAuth2ScopeList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeList listOAuth2Scopes() {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/scopes", OAuth2ScopeList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeRefreshTokensForClient(String clientId) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens", queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKeyList rotateKeys(JwkUse use) {
        String authServerId = this.getId();
        Assert.notNull((Object)use, (String)"'use' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/credentials/lifecycle/keyRotate", use, this, JsonWebKeyList.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshTokenList listRefreshTokensForClient(String clientId, String expand) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens", OAuth2RefreshTokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshTokenList listRefreshTokensForClient(String clientId) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens", OAuth2RefreshTokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    @Override
    public void delete() {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Claim updateOAuth2Claim(String claimId, OAuth2Claim oAuth2Claim) {
        String authServerId = this.getId();
        Assert.notNull((Object)oAuth2Claim, (String)"'oAuth2Claim' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)claimId, (String)"'claimId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authorizationServers/" + authServerId + "/claims/" + claimId + "";
        this.getDataStore().save(href, oAuth2Claim, this, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return oAuth2Claim;
    }

    public OAuth2RefreshToken getRefreshTokenForClient(String clientId, String tokenId, String expand) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens/" + tokenId + "", OAuth2RefreshToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshToken getRefreshTokenForClient(String clientId, String tokenId) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens/" + tokenId + "", OAuth2RefreshToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Policy updatePolicy(String policyId, Policy policy) {
        String authServerId = this.getId();
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "";
        this.getDataStore().save(href, policy, this, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policy;
    }

    public void revokeRefreshTokenForClient(String clientId, String tokenId) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens/" + tokenId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void deletePolicy(String policyId) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public Policy getPolicy(String policyId) {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "", Policy.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServer update() {
        String authServerId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authorizationServers/" + authServerId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public OAuth2Scope updateOAuth2Scope(String scopeId, OAuth2Scope oAuth2Scope) {
        String authServerId = this.getId();
        Assert.notNull((Object)oAuth2Scope, (String)"'oAuth2Scope' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)scopeId, (String)"'scopeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authorizationServers/" + authServerId + "/scopes/" + scopeId + "";
        this.getDataStore().save(href, oAuth2Scope, this, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return oAuth2Scope;
    }

    public OAuth2Claim createOAuth2Claim(OAuth2Claim oAuth2Claim) {
        String authServerId = this.getId();
        Assert.notNull((Object)oAuth2Claim, (String)"'oAuth2Claim' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/claims", oAuth2Claim, this, OAuth2Claim.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return oAuth2Claim;
    }
}

