/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.okta.sdk.impl.oauth2.DPoPHandshakeException;
import com.okta.sdk.impl.oauth2.DPopHandshakeState;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.security.Jwks;
import io.jsonwebtoken.security.PrivateJwk;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DPoPInterceptor
implements ExecChainHandler {
    private static final Logger log = LoggerFactory.getLogger(DPoPInterceptor.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String DPOP_HEADER = "DPoP";
    private static final int NONCE_VALID_SECONDS = 79200;
    private static final ThreadLocal<MessageDigest> SHA256 = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    });
    private PrivateJwk<PrivateKey, PublicKey, ?> jwk;
    private String nonce;
    private Instant nonceValidUntil;

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain execChain) throws IOException, HttpException {
        boolean tokenRequest = request.getRequestUri().equals("/oauth2/v1/token");
        if (tokenRequest && this.nonce != null && this.nonceValidUntil.isBefore(Instant.now())) {
            log.debug("DPoP nonce expired, will refresh it");
            this.nonce = null;
            this.nonceValidUntil = null;
        }
        if (this.jwk != null) {
            this.processRequest((HttpRequest)request, tokenRequest);
        }
        ClassicHttpResponse response = execChain.proceed(request, scope);
        if (tokenRequest) {
            if (response.getCode() == 200 && this.nonce != null) {
                log.info("DPoP handshake successful");
            }
            if (response.getCode() == 400) {
                JsonNode errorBody = OBJECT_MAPPER.readTree(response.getEntity().getContent());
                Header nonceHeader = response.getFirstHeader("dpop-nonce");
                DPopHandshakeState handshakeState = this.handleHandshakeResponse(errorBody.get("error"), nonceHeader);
                throw new DPoPHandshakeException(handshakeState, OBJECT_MAPPER.writeValueAsString((Object)errorBody));
            }
        }
        return response;
    }

    private void processRequest(HttpRequest request, boolean tokenRequest) {
        JwtBuilder builder = ((JwtBuilder)((JwtBuilder.BuilderHeader)((JwtBuilder.BuilderHeader)Jwts.builder().header().type("dpop+jwt")).jwk(this.jwk.toPublicJwk())).and()).claim("htm", (Object)request.getMethod()).claim("htu", (Object)this.getUriWithoutQueryString(request)).claim("jti", (Object)UUID.randomUUID().toString()).issuedAt(new Date());
        Header authorization = request.getFirstHeader("Authorization");
        if (authorization != null) {
            String token = StringUtils.substringAfter((String)authorization.getValue(), (String)" ");
            request.setHeader("Authorization", (Object)("DPoP " + token));
            byte[] ath = SHA256.get().digest(token.getBytes(StandardCharsets.US_ASCII));
            builder.claim("ath", Encoders.BASE64URL.encode((Object)ath));
        } else if (tokenRequest && this.nonce != null) {
            builder.claim("nonce", (Object)this.nonce);
        }
        request.addHeader(DPOP_HEADER, (Object)builder.signWith((Key)this.jwk.toKeyPair().getPrivate()).compact());
    }

    private String getUriWithoutQueryString(HttpRequest request) {
        try {
            String urlWithoutQueryString = StringUtils.substringBefore((String)request.getUri().toString(), (String)"?");
            return URLDecoder.decode(urlWithoutQueryString, StandardCharsets.UTF_8.name()).replace("%", "%25").replace(" ", "%20").replace("\"", "%22").replace("#", "%23");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DPopHandshakeState handleHandshakeResponse(JsonNode errorField, Header nonceHeader) {
        if (errorField != null && errorField.isTextual()) {
            switch (errorField.textValue()) {
                case "invalid_dpop_proof": {
                    if (this.jwk != null) {
                        return DPopHandshakeState.REPEATED_INVALID_DPOP_PROOF;
                    }
                    log.info("DPoP detected, beginning handshake");
                    this.jwk = (PrivateJwk)Jwks.builder().keyPair((KeyPair)Jwts.SIG.ES256.keyPair().build()).build();
                    return DPopHandshakeState.FIRST_INVALID_DPOP_PROOF;
                }
                case "use_dpop_nonce": {
                    if (this.nonce != null) {
                        return DPopHandshakeState.REPEATED_USE_DPOP_NONCE;
                    }
                    if (nonceHeader == null) {
                        return DPopHandshakeState.MISSING_DPOP_NONCE_HEADER;
                    }
                    log.info("DPoP nonce obtained, finalizing handshake");
                    this.nonce = nonceHeader.getValue();
                    this.nonceValidUntil = Instant.now().plusSeconds(79200L);
                    return DPopHandshakeState.FIRST_USE_DPOP_NONCE;
                }
            }
            return DPopHandshakeState.UNEXPECTED_STATE;
        }
        return DPopHandshakeState.UNEXPECTED_STATE;
    }
}

