/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.Objects;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.AccessPolicy;
import org.openapitools.client.model.AuthorizationServerPolicy;
import org.openapitools.client.model.IdentityProviderPolicy;
import org.openapitools.client.model.MultifactorEnrollmentPolicy;
import org.openapitools.client.model.OktaSignOnPolicy;
import org.openapitools.client.model.PasswordPolicy;
import org.openapitools.client.model.Policy;
import org.openapitools.client.model.ProfileEnrollmentPolicy;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class PolicyDeserializer
extends StdDeserializer<Policy> {
    private ObjectMapper objectMapper;

    public PolicyDeserializer() {
        this(null);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.registerModule((Module)new JsonNullableModule());
        this.objectMapper.setDateFormat(ApiClient.buildDefaultDateFormat());
    }

    public PolicyDeserializer(Class<?> vc) {
        super(vc);
    }

    public Policy deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Policy policy = (Policy)this.objectMapper.convertValue((Object)node, Policy.class);
        switch (Objects.requireNonNull(policy.getType())) {
            case ACCESS_POLICY: {
                return (Policy)this.objectMapper.convertValue((Object)node, AccessPolicy.class);
            }
            case IDP_DISCOVERY: {
                return (Policy)this.objectMapper.convertValue((Object)node, IdentityProviderPolicy.class);
            }
            case MFA_ENROLL: {
                return (Policy)this.objectMapper.convertValue((Object)node, MultifactorEnrollmentPolicy.class);
            }
            case OAUTH_AUTHORIZATION_POLICY: {
                return (Policy)this.objectMapper.convertValue((Object)node, AuthorizationServerPolicy.class);
            }
            case OKTA_SIGN_ON: {
                return (Policy)this.objectMapper.convertValue((Object)node, OktaSignOnPolicy.class);
            }
            case PASSWORD: {
                return (Policy)this.objectMapper.convertValue((Object)node, PasswordPolicy.class);
            }
            case PROFILE_ENROLLMENT: {
                return (Policy)this.objectMapper.convertValue((Object)node, ProfileEnrollmentPolicy.class);
            }
        }
        return (Policy)this.objectMapper.convertValue((Object)node, Policy.class);
    }
}

