/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.resource.user.UserBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.client.api.UserApi;
import org.openapitools.client.model.AuthenticationProvider;
import org.openapitools.client.model.CreateUserRequest;
import org.openapitools.client.model.PasswordCredential;
import org.openapitools.client.model.PasswordCredentialHash;
import org.openapitools.client.model.PasswordCredentialHook;
import org.openapitools.client.model.RecoveryQuestionCredential;
import org.openapitools.client.model.User;
import org.openapitools.client.model.UserCredentials;
import org.openapitools.client.model.UserProfile;
import org.openapitools.client.model.UserType;

public class DefaultUserBuilder
implements UserBuilder {
    private char[] password;
    private String securityQuestion;
    private String securityQuestionAnswer;
    private String email;
    private String login;
    private String secondEmail;
    private String firstName;
    private String lastName;
    private String mobilePhone;
    private Boolean active;
    private AuthenticationProvider provider;
    private UserType userType;
    private String userTypeId;
    private String nextLogin;
    private List<String> groupIds = new ArrayList<String>();
    private Map<String, Object> passwordHashProperties;
    private String passwordHookImportType;

    public UserBuilder setPassword(char[] password) {
        this.password = Arrays.copyOf(password, password.length);
        return this;
    }

    public UserBuilder usePasswordHookForImport() {
        return this.usePasswordHookForImport("default");
    }

    public UserBuilder usePasswordHookForImport(String type) {
        this.passwordHookImportType = type;
        return this;
    }

    public UserBuilder setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
        return this;
    }

    public UserBuilder setSecurityQuestionAnswer(String answer) {
        this.securityQuestionAnswer = answer;
        return this;
    }

    public UserBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public UserBuilder setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public UserBuilder setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public UserBuilder setLogin(String login) {
        this.login = login;
        return this;
    }

    public UserBuilder setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public UserBuilder setSecondEmail(String secondEmail) {
        this.secondEmail = secondEmail;
        return this;
    }

    public UserBuilder setActive(Boolean active) {
        this.active = active;
        return this;
    }

    public UserBuilder setProvider(AuthenticationProvider provider) {
        this.provider = provider;
        return this;
    }

    public UserBuilder setType(UserType userType) {
        this.userType = userType;
        return this;
    }

    public UserBuilder setType(String userTypeId) {
        this.userTypeId = userTypeId;
        return this;
    }

    public UserBuilder setGroups(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public UserBuilder addGroup(String groupId) {
        this.groupIds.add(groupId);
        return this;
    }

    public UserBuilder setNextLogin(String nextLogin) {
        this.nextLogin = nextLogin;
        return this;
    }

    private CreateUserRequest build() {
        PasswordCredential passwordCredential;
        CreateUserRequest createUserRequest = new CreateUserRequest();
        createUserRequest.setProfile(new UserProfile());
        UserProfile userProfile = createUserRequest.getProfile();
        if (Strings.hasText((String)this.firstName)) {
            userProfile.setFirstName(this.firstName);
        }
        if (Strings.hasText((String)this.lastName)) {
            userProfile.setLastName(this.lastName);
        }
        if (Strings.hasText((String)this.email)) {
            userProfile.setEmail(this.email);
        }
        if (Strings.hasText((String)this.secondEmail)) {
            userProfile.setSecondEmail(this.secondEmail);
        }
        if (Strings.hasText((String)this.mobilePhone)) {
            userProfile.setMobilePhone(this.mobilePhone);
        }
        if (Strings.hasText((String)this.login)) {
            userProfile.setLogin(this.login);
        } else {
            userProfile.setLogin(this.email);
        }
        if (Strings.hasText((String)this.userTypeId)) {
            UserType userType = new UserType();
            userType.setId(this.userTypeId);
            createUserRequest.setType(userType);
        } else if (this.userType != null) {
            createUserRequest.setType(this.userType);
        }
        if (!Collections.isEmpty(this.groupIds)) {
            createUserRequest.setGroupIds(this.groupIds);
        }
        if (Strings.hasText((String)this.securityQuestion)) {
            RecoveryQuestionCredential question = new RecoveryQuestionCredential();
            question.setQuestion(this.securityQuestion);
            question.setAnswer(this.securityQuestionAnswer);
            this.createCredentialsIfNeeded(createUserRequest).setRecoveryQuestion(question);
        }
        if (this.provider != null) {
            this.createCredentialsIfNeeded(createUserRequest).setProvider(this.provider);
        }
        if (this.password != null && this.password.length > 0) {
            if (this.passwordHashProperties != null) {
                throw new IllegalArgumentException("Cannot specify both password and password hash, use one or the other.");
            }
            passwordCredential = new PasswordCredential();
            passwordCredential.setValue(new String(this.password));
            this.createCredentialsIfNeeded(createUserRequest).setPassword(passwordCredential);
        }
        if (this.passwordHashProperties != null) {
            passwordCredential = new PasswordCredential();
            PasswordCredentialHash passwordCredentialHash = new PasswordCredentialHash();
            passwordCredentialHash.setAlgorithm((String)this.passwordHashProperties.get("algorithm"));
            passwordCredentialHash.setWorkFactor((Integer)this.passwordHashProperties.get("workFactor"));
            passwordCredentialHash.setSalt((String)this.passwordHashProperties.get("salt"));
            passwordCredentialHash.setValue((String)this.passwordHashProperties.get("value"));
            passwordCredentialHash.setSaltOrder((String)this.passwordHashProperties.get("saltOrder"));
            passwordCredential.setHash(passwordCredentialHash);
            this.createCredentialsIfNeeded(createUserRequest).setPassword(passwordCredential);
        }
        if (this.passwordHookImportType != null) {
            passwordCredential = new PasswordCredential();
            PasswordCredentialHook passwordCredentialHook = new PasswordCredentialHook();
            passwordCredentialHook.setType(this.passwordHookImportType);
            passwordCredential.setHook(passwordCredentialHook);
            this.createCredentialsIfNeeded(createUserRequest).setPassword(passwordCredential);
        }
        return createUserRequest;
    }

    private UserCredentials createCredentialsIfNeeded(CreateUserRequest createUserRequest) {
        if (createUserRequest.getCredentials() == null) {
            UserCredentials credentials = new UserCredentials();
            createUserRequest.setCredentials(credentials);
        }
        return createUserRequest.getCredentials();
    }

    public UserBuilder setBcryptPasswordHash(String value, String salt, int workFactor) {
        this.passwordHashProperties = new HashMap<String, Object>();
        this.passwordHashProperties.put("algorithm", "BCRYPT");
        this.passwordHashProperties.put("workFactor", workFactor);
        this.passwordHashProperties.put("salt", salt);
        this.passwordHashProperties.put("value", value);
        return this;
    }

    public UserBuilder setSha256PasswordHash(String value, String salt, String saltOrder) {
        return this.setShaPasswordHash("SHA-256", value, salt, saltOrder);
    }

    public UserBuilder setSha512PasswordHash(String value, String salt, String saltOrder) {
        return this.setShaPasswordHash("SHA-512", value, salt, saltOrder);
    }

    public UserBuilder setSha1PasswordHash(String value, String salt, String saltOrder) {
        return this.setShaPasswordHash("SHA-1", value, salt, saltOrder);
    }

    private UserBuilder setShaPasswordHash(String shaAlgorithm, String value, String salt, String saltOrder) {
        this.passwordHashProperties = new HashMap<String, Object>();
        this.passwordHashProperties.put("algorithm", shaAlgorithm);
        this.passwordHashProperties.put("salt", salt);
        this.passwordHashProperties.put("value", value);
        this.passwordHashProperties.put("saltOrder", saltOrder);
        return this;
    }

    public User buildAndCreate(UserApi client) {
        return client.createUser(this.build(), this.active, Boolean.valueOf(this.provider != null), this.nextLogin);
    }
}

