/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.impl.resource.DefaultPolicyBuilder;
import com.okta.sdk.resource.policy.PasswordPolicyBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openapitools.client.api.PolicyApi;
import org.openapitools.client.model.GroupCondition;
import org.openapitools.client.model.PasswordDictionary;
import org.openapitools.client.model.PasswordDictionaryCommon;
import org.openapitools.client.model.PasswordPolicy;
import org.openapitools.client.model.PasswordPolicyAuthenticationProviderCondition;
import org.openapitools.client.model.PasswordPolicyConditions;
import org.openapitools.client.model.PasswordPolicyDelegationSettings;
import org.openapitools.client.model.PasswordPolicyDelegationSettingsOptions;
import org.openapitools.client.model.PasswordPolicyPasswordSettings;
import org.openapitools.client.model.PasswordPolicyPasswordSettingsAge;
import org.openapitools.client.model.PasswordPolicyPasswordSettingsComplexity;
import org.openapitools.client.model.PasswordPolicyPasswordSettingsLockout;
import org.openapitools.client.model.PasswordPolicyRecoveryEmail;
import org.openapitools.client.model.PasswordPolicyRecoveryEmailProperties;
import org.openapitools.client.model.PasswordPolicyRecoveryEmailRecoveryToken;
import org.openapitools.client.model.PasswordPolicyRecoveryFactorSettings;
import org.openapitools.client.model.PasswordPolicyRecoveryFactors;
import org.openapitools.client.model.PasswordPolicyRecoverySettings;
import org.openapitools.client.model.PasswordPolicySettings;
import org.openapitools.client.model.Policy;
import org.openapitools.client.model.PolicyPeopleCondition;
import org.openapitools.client.model.UserCondition;

public class DefaultPasswordPolicyBuilder
extends DefaultPolicyBuilder<PasswordPolicyBuilder>
implements PasswordPolicyBuilder {
    private String provider;
    private List<String> groupIds = new ArrayList<String>();
    private List<String> userIds = new ArrayList<String>();
    private Boolean excludePasswordDictionary;
    private Boolean excludeUserNameInPassword;
    private Integer minPasswordLength;
    private Integer minLowercase;
    private Integer minUpperCase;
    private Integer minNumbers;
    private Integer minSymbols;
    private Boolean skipUnlock;
    private Integer pwdExpireWarnDays;
    private Integer pwdHistoryCount;
    private Integer pwdMaxAgeDays;
    private Integer pwdMinMinutes;
    private Integer pwdAutoUnlockMinutes;
    private Integer pwdMaxAttempts;
    private Boolean showLockoutFailures;
    private PasswordPolicyRecoveryFactorSettings pwdRecoveryOktaCall;
    private PasswordPolicyRecoveryFactorSettings pwdRecoveryOktaSMS;
    private PasswordPolicyRecoveryFactorSettings pwdPolicyRecoveryEmailStatus;
    private Integer pwdRecoveryTokenLifeMinutes;

    public DefaultPasswordPolicyBuilder() {
        this.policyType = "PASSWORD";
    }

    public PasswordPolicyBuilder setAuthProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public PasswordPolicyBuilder setGroups(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public PasswordPolicyBuilder addGroup(String groupId) {
        this.groupIds.add(groupId);
        return this;
    }

    public PasswordPolicyBuilder setUsers(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    public PasswordPolicyBuilder addUser(String userId) {
        this.userIds.add(userId);
        return this;
    }

    public PasswordPolicyBuilder setExcludePasswordDictionary(Boolean enablePasswordDictionary) {
        this.excludePasswordDictionary = enablePasswordDictionary;
        return this;
    }

    public PasswordPolicyBuilder setExcludeUserNameInPassword(Boolean excludeUserNameInPassword) {
        this.excludeUserNameInPassword = excludeUserNameInPassword;
        return this;
    }

    public PasswordPolicyBuilder setMinPasswordLength(Integer minPasswordLength) {
        this.minPasswordLength = minPasswordLength;
        return this;
    }

    public PasswordPolicyBuilder setMinLowerCase(Integer minLowerCase) {
        this.minLowercase = minLowerCase;
        return this;
    }

    public PasswordPolicyBuilder setMinUpperCase(Integer minUpperCase) {
        this.minUpperCase = minUpperCase;
        return this;
    }

    public PasswordPolicyBuilder setMinNumbers(Integer minNumbers) {
        this.minNumbers = minNumbers;
        return this;
    }

    public PasswordPolicyBuilder setMinSymbols(Integer minSymbols) {
        this.minSymbols = minSymbols;
        return this;
    }

    public PasswordPolicyBuilder setSkipUnlock(Boolean skipUnlock) {
        this.skipUnlock = skipUnlock;
        return this;
    }

    public PasswordPolicyBuilder setPasswordExpireWarnDays(Integer pwdExpireWarnDays) {
        this.pwdExpireWarnDays = pwdExpireWarnDays;
        return this;
    }

    public PasswordPolicyBuilder setPasswordHistoryCount(Integer pwdHistoryCount) {
        this.pwdHistoryCount = pwdHistoryCount;
        return this;
    }

    public PasswordPolicyBuilder setPasswordMaxAgeDays(Integer pwdMaxAgeDays) {
        this.pwdMaxAgeDays = pwdMaxAgeDays;
        return this;
    }

    public PasswordPolicyBuilder setPasswordMinMinutes(Integer pwdMinMinutes) {
        this.pwdMinMinutes = pwdMinMinutes;
        return this;
    }

    public PasswordPolicyBuilder setPasswordAutoUnlockMinutes(Integer pwdAutoUnlockMinutes) {
        this.pwdAutoUnlockMinutes = pwdAutoUnlockMinutes;
        return this;
    }

    public PasswordPolicyBuilder setPasswordMaxAttempts(Integer pwdMaxAttempts) {
        this.pwdMaxAttempts = pwdMaxAttempts;
        return this;
    }

    public PasswordPolicyBuilder setShowLockoutFailures(Boolean showLockoutFailures) {
        this.showLockoutFailures = showLockoutFailures;
        return this;
    }

    public PasswordPolicyBuilder setPasswordRecoveryOktaCall(PasswordPolicyRecoveryFactorSettings pwdRecoveryOktaCall) {
        this.pwdRecoveryOktaCall = pwdRecoveryOktaCall;
        return this;
    }

    public PasswordPolicyBuilder setPasswordRecoveryOktaSMS(PasswordPolicyRecoveryFactorSettings pwdRecoveryOktaSMS) {
        this.pwdRecoveryOktaSMS = pwdRecoveryOktaSMS;
        return this;
    }

    public PasswordPolicyBuilder setPasswordPolicyRecoveryEmailStatus(PasswordPolicyRecoveryFactorSettings status) {
        this.pwdPolicyRecoveryEmailStatus = status;
        return this;
    }

    public PasswordPolicyBuilder setPasswordRecoveryTokenLifeMinutes(Integer pwdRecoveryTokenLifeMinutes) {
        this.pwdRecoveryTokenLifeMinutes = pwdRecoveryTokenLifeMinutes;
        return this;
    }

    public PasswordPolicy buildAndCreate(PolicyApi client) {
        return (PasswordPolicy)client.createPolicy((Policy)this.build(), this.isActive);
    }

    private PasswordPolicy build() {
        PasswordPolicyRecoveryFactorSettings passwordPolicyRecoveryFactorSettings;
        PolicyPeopleCondition policyPeopleCondition;
        PasswordPolicy policy = new PasswordPolicy();
        policy.setConditions(new PasswordPolicyConditions());
        PasswordPolicyConditions passwordPolicyConditions = policy.getConditions();
        policy.setSettings(new PasswordPolicySettings());
        PasswordPolicySettings passwordPolicySettings = policy.getSettings();
        if (Strings.hasText((String)this.name)) {
            policy.setName(this.name);
        }
        if (Strings.hasText((String)this.description)) {
            policy.setDescription(this.description);
        }
        if (this.priority != null) {
            policy.setPriority(this.priority);
        }
        if (!this.policyType.equals("PASSWORD")) {
            throw new IllegalArgumentException("PolicyType should be 'PASSWORD', please use PolicyBuilder for other policy types.");
        }
        policy.setType(this.policyType);
        if (Objects.nonNull(this.status)) {
            policy.setStatus(this.status);
        }
        if (Objects.nonNull(this.provider)) {
            PasswordPolicyAuthenticationProviderCondition passwordPolicyAuthenticationProviderCondition = new PasswordPolicyAuthenticationProviderCondition();
            passwordPolicyAuthenticationProviderCondition.setProvider(this.provider);
            passwordPolicyConditions.setAuthProvider(passwordPolicyAuthenticationProviderCondition);
        }
        if (!Collections.isEmpty(this.groupIds)) {
            GroupCondition groupCondition = new GroupCondition();
            groupCondition.setInclude(this.groupIds);
            policyPeopleCondition = new PolicyPeopleCondition();
            policyPeopleCondition.setGroups(groupCondition);
            passwordPolicyConditions.setPeople(policyPeopleCondition);
        }
        if (!Collections.isEmpty(this.userIds)) {
            UserCondition userCondition = new UserCondition();
            userCondition.setInclude(this.userIds);
            policyPeopleCondition = new PolicyPeopleCondition();
            policyPeopleCondition.setUsers(userCondition);
            passwordPolicyConditions.setPeople(policyPeopleCondition);
        }
        PasswordPolicyPasswordSettings passwordPolicyPasswordSettings = new PasswordPolicyPasswordSettings();
        PasswordPolicyPasswordSettingsComplexity passwordPolicyPasswordSettingsComplexity = new PasswordPolicyPasswordSettingsComplexity();
        if (Objects.nonNull(this.excludePasswordDictionary)) {
            PasswordDictionaryCommon passwordDictionaryCommon = new PasswordDictionaryCommon();
            passwordDictionaryCommon.setExclude(this.excludePasswordDictionary);
            PasswordDictionary passwordDictionary = new PasswordDictionary();
            passwordDictionary.setCommon(passwordDictionaryCommon);
            passwordPolicyPasswordSettingsComplexity.setDictionary(passwordDictionary);
            passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        if (Objects.nonNull(this.excludeUserNameInPassword)) {
            passwordPolicyPasswordSettingsComplexity.setExcludeUsername(this.excludeUserNameInPassword);
            passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        if (Objects.nonNull(this.minPasswordLength)) {
            passwordPolicyPasswordSettingsComplexity.setMinLength(this.minPasswordLength);
            passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        if (Objects.nonNull(this.minLowercase)) {
            passwordPolicyPasswordSettingsComplexity.setMinLowerCase(this.minLowercase);
            passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        if (Objects.nonNull(this.minUpperCase)) {
            passwordPolicyPasswordSettingsComplexity.setMinUpperCase(this.minUpperCase);
            passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        if (Objects.nonNull(this.minNumbers)) {
            passwordPolicyPasswordSettingsComplexity.setMinNumber(this.minNumbers);
            passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        if (Objects.nonNull(this.minSymbols)) {
            passwordPolicyPasswordSettingsComplexity.setMinSymbol(this.minSymbols);
            passwordPolicyPasswordSettings.setComplexity(passwordPolicyPasswordSettingsComplexity);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        if (Objects.nonNull(this.skipUnlock)) {
            PasswordPolicyDelegationSettingsOptions passwordPolicyDelegationSettingsOptions = new PasswordPolicyDelegationSettingsOptions();
            passwordPolicyDelegationSettingsOptions.setSkipUnlock(this.skipUnlock);
            PasswordPolicyDelegationSettings passwordPolicyDelegationSettings = new PasswordPolicyDelegationSettings();
            passwordPolicyDelegationSettings.setOptions(passwordPolicyDelegationSettingsOptions);
            passwordPolicySettings.setDelegation(passwordPolicyDelegationSettings);
        }
        PasswordPolicyPasswordSettingsAge passwordPolicyPasswordSettingsAge = new PasswordPolicyPasswordSettingsAge();
        if (Objects.nonNull(this.pwdExpireWarnDays)) {
            passwordPolicyPasswordSettingsAge.setExpireWarnDays(this.pwdExpireWarnDays);
            passwordPolicyPasswordSettings.setAge(passwordPolicyPasswordSettingsAge);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        if (Objects.nonNull(this.pwdHistoryCount)) {
            passwordPolicyPasswordSettingsAge.setHistoryCount(this.pwdHistoryCount);
            passwordPolicyPasswordSettings.setAge(passwordPolicyPasswordSettingsAge);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        if (Objects.nonNull(this.pwdMaxAgeDays)) {
            passwordPolicyPasswordSettingsAge.setMaxAgeDays(this.pwdMaxAgeDays);
            passwordPolicyPasswordSettings.setAge(passwordPolicyPasswordSettingsAge);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        if (Objects.nonNull(this.pwdMinMinutes)) {
            passwordPolicyPasswordSettingsAge.setMinAgeMinutes(this.pwdMinMinutes);
            passwordPolicyPasswordSettings.setAge(passwordPolicyPasswordSettingsAge);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        PasswordPolicyPasswordSettingsLockout passwordPolicyPasswordSettingsLockout = new PasswordPolicyPasswordSettingsLockout();
        if (Objects.nonNull(this.pwdAutoUnlockMinutes)) {
            passwordPolicyPasswordSettingsLockout.setAutoUnlockMinutes(this.pwdAutoUnlockMinutes);
            passwordPolicyPasswordSettings.setLockout(passwordPolicyPasswordSettingsLockout);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        if (Objects.nonNull(this.pwdMaxAttempts)) {
            passwordPolicyPasswordSettingsLockout.setMaxAttempts(this.pwdMaxAttempts);
            passwordPolicyPasswordSettings.setLockout(passwordPolicyPasswordSettingsLockout);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        if (Objects.nonNull(this.showLockoutFailures)) {
            passwordPolicyPasswordSettingsLockout.setShowLockoutFailures(this.showLockoutFailures);
            passwordPolicyPasswordSettings.setLockout(passwordPolicyPasswordSettingsLockout);
            passwordPolicySettings.setPassword(passwordPolicyPasswordSettings);
        }
        PasswordPolicyRecoverySettings passwordPolicyRecoverySettings = new PasswordPolicyRecoverySettings();
        PasswordPolicyRecoveryFactors passwordPolicyRecoveryFactors = new PasswordPolicyRecoveryFactors();
        if (Objects.nonNull(this.pwdRecoveryOktaCall)) {
            passwordPolicyRecoveryFactorSettings = new PasswordPolicyRecoveryFactorSettings();
            passwordPolicyRecoveryFactorSettings.setStatus(this.pwdRecoveryOktaCall.getStatus());
            passwordPolicyRecoveryFactors.setOktaCall(passwordPolicyRecoveryFactorSettings);
            passwordPolicyRecoverySettings.setFactors(passwordPolicyRecoveryFactors);
            passwordPolicySettings.setRecovery(passwordPolicyRecoverySettings);
        }
        if (Objects.nonNull(this.pwdRecoveryOktaSMS)) {
            passwordPolicyRecoveryFactorSettings = new PasswordPolicyRecoveryFactorSettings();
            passwordPolicyRecoveryFactorSettings.setStatus(this.pwdRecoveryOktaSMS.getStatus());
            passwordPolicyRecoveryFactors.setOktaSms(passwordPolicyRecoveryFactorSettings);
            passwordPolicyRecoverySettings.setFactors(passwordPolicyRecoveryFactors);
            passwordPolicySettings.setRecovery(passwordPolicyRecoverySettings);
        }
        PasswordPolicyRecoveryEmail passwordPolicyRecoveryEmail = new PasswordPolicyRecoveryEmail();
        if (Objects.nonNull(this.pwdPolicyRecoveryEmailStatus)) {
            passwordPolicyRecoveryEmail.setStatus(this.pwdPolicyRecoveryEmailStatus.getStatus());
        }
        if (Objects.nonNull(this.pwdRecoveryTokenLifeMinutes)) {
            PasswordPolicyRecoveryEmailRecoveryToken passwordPolicyRecoveryEmailRecoveryToken = new PasswordPolicyRecoveryEmailRecoveryToken();
            passwordPolicyRecoveryEmailRecoveryToken.setTokenLifetimeMinutes(this.pwdRecoveryTokenLifeMinutes);
            PasswordPolicyRecoveryEmailProperties passwordPolicyRecoveryEmailProperties = new PasswordPolicyRecoveryEmailProperties();
            passwordPolicyRecoveryEmailProperties.setRecoveryToken(passwordPolicyRecoveryEmailRecoveryToken);
            passwordPolicyRecoveryEmail.setProperties(passwordPolicyRecoveryEmailProperties);
            passwordPolicyRecoveryFactors.setOktaEmail(passwordPolicyRecoveryEmail);
            passwordPolicyRecoverySettings.setFactors(passwordPolicyRecoveryFactors);
            passwordPolicySettings.setRecovery(passwordPolicyRecoverySettings);
        }
        return policy;
    }
}

