/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.user;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.user.AppLinkList;
import com.okta.sdk.resource.user.ChangePasswordRequest;
import com.okta.sdk.resource.user.ForgotPasswordResponse;
import com.okta.sdk.resource.user.ResetPasswordToken;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.RoleList;
import com.okta.sdk.resource.user.TempPassword;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserActivationToken;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.UserProfile;
import com.okta.sdk.resource.user.UserStatus;
import com.okta.sdk.resource.user.factor.Factor;
import com.okta.sdk.resource.user.factor.FactorList;
import com.okta.sdk.resource.user.factor.SecurityQuestionList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultUser
extends AbstractInstanceResource<User>
implements User {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final DateProperty activatedProperty = new DateProperty("activated");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final ResourceReference<UserCredentials> credentialsProperty = new ResourceReference<UserCredentials>("credentials", UserCredentials.class, false);
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastLoginProperty = new DateProperty("lastLogin");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final DateProperty passwordChangedProperty = new DateProperty("passwordChanged");
    private static final ResourceReference<UserProfile> profileProperty = new ResourceReference<UserProfile>("profile", UserProfile.class, true);
    private static final EnumProperty<UserStatus> statusProperty = new EnumProperty<UserStatus>("status", UserStatus.class);
    private static final DateProperty statusChangedProperty = new DateProperty("statusChanged");
    private static final EnumProperty<UserStatus> transitioningToStatusProperty = new EnumProperty<UserStatus>("transitioningToStatus", UserStatus.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultUser.createPropertyDescriptorMap(embeddedProperty, linksProperty, activatedProperty, createdProperty, credentialsProperty, idProperty, lastLoginProperty, lastUpdatedProperty, passwordChangedProperty, profileProperty, statusProperty, statusChangedProperty, transitioningToStatusProperty);

    public DefaultUser(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultUser(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return User.class;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Date getActivated() {
        return this.getDateProperty(activatedProperty);
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public UserCredentials getCredentials() {
        return this.getResourceProperty(credentialsProperty);
    }

    public User setCredentials(UserCredentials credentials) {
        this.setProperty(credentialsProperty, (Object)credentials);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastLogin() {
        return this.getDateProperty(lastLoginProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public Date getPasswordChanged() {
        return this.getDateProperty(passwordChangedProperty);
    }

    public UserProfile getProfile() {
        return this.getResourceProperty(profileProperty);
    }

    public User setProfile(UserProfile profile) {
        this.setProperty(profileProperty, (Object)profile);
        return this;
    }

    public UserStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public Date getStatusChanged() {
        return this.getDateProperty(statusChangedProperty);
    }

    public UserStatus getTransitioningToStatus() {
        return this.getEnumProperty(transitioningToStatusProperty);
    }

    public void deactivate(Boolean sendEmail) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivate() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ResetPasswordToken resetPassword(String provider, Boolean sendEmail) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (provider != null) {
            queryArgs.put("provider", provider);
        }
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/reset_password", new DefaultVoidResource(this.getDataStore()), this, ResetPasswordToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ResetPasswordToken resetPassword() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/reset_password", new DefaultVoidResource(this.getDataStore()), this, ResetPasswordToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public FactorList listFactors() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors", FactorList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listGroupTargetsForRole(String roleId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ForgotPasswordResponse forgotPassword(UserCredentials userCredentials, Boolean sendEmail) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/forgot_password", userCredentials != null ? userCredentials : this.getDataStore().instantiate(VoidResource.class), this, ForgotPasswordResponse.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public ForgotPasswordResponse forgotPassword() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/forgot_password", new DefaultVoidResource(this.getDataStore()), null, ForgotPasswordResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeRole(String roleId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/roles/" + roleId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public TempPassword expirePassword(Boolean tempPassword) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (tempPassword != null) {
            queryArgs.put("tempPassword", tempPassword);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/expire_password", new DefaultVoidResource(this.getDataStore()), this, TempPassword.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public TempPassword expirePassword() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/expire_password", new DefaultVoidResource(this.getDataStore()), this, TempPassword.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserActivationToken activate(Boolean sendEmail) {
        String userId = this.getId();
        Assert.notNull((Object)sendEmail, (String)"'sendEmail' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, UserActivationToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserCredentials changeRecoveryQuestion(UserCredentials userCredentials) {
        String userId = this.getId();
        Assert.notNull((Object)userCredentials, (String)"'userCredentials' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/credentials/change_recovery_question", userCredentials, this, UserCredentials.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return userCredentials;
    }

    public void unsuspend() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/unsuspend", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Factor addFactor(Factor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) {
        String userId = this.getId();
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (updatePhone != null) {
            queryArgs.put("updatePhone", updatePhone);
        }
        if (templateId != null) {
            queryArgs.put("templateId", templateId);
        }
        if (tokenLifetimeSeconds != null) {
            queryArgs.put("tokenLifetimeSeconds", tokenLifetimeSeconds);
        }
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/factors", body, this, Factor.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public Factor addFactor(Factor body) {
        String userId = this.getId();
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/factors", body, this, Factor.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public Factor addFactor(Factor body, Boolean updatePhone, String templateId) {
        String userId = this.getId();
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        if (updatePhone != null) {
            queryArgs.put("updatePhone", updatePhone);
        }
        if (templateId != null) {
            queryArgs.put("templateId", templateId);
        }
        this.getDataStore().create("/api/v1/users/" + userId + "/factors", body, null, Factor.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public GroupList listGroups() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeGroupTargetFromRole(String roleId, String groupId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups/" + groupId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public FactorList listSupportedFactors() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors/catalog", FactorList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void delete(Boolean sendEmail) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    @Override
    public void delete() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    public void resetFactors() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/reset_factors", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void suspend() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/suspend", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public RoleList listRoles(String expand) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/roles", RoleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public RoleList listRoles() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/roles", RoleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void unlock() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/unlock", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public User update(Boolean strict) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (strict != null) {
            queryArgs.put("strict", strict);
        }
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public User update() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public Factor getFactor(String factorId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors/" + factorId + "", Factor.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserCredentials changePassword(ChangePasswordRequest changePasswordRequest, Boolean strict) {
        String userId = this.getId();
        Assert.notNull((Object)changePasswordRequest, (String)"'changePasswordRequest' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (strict != null) {
            queryArgs.put("strict", strict);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/change_password", changePasswordRequest, this, UserCredentials.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public UserCredentials changePassword(ChangePasswordRequest changePasswordRequest) {
        String userId = this.getId();
        Assert.notNull((Object)changePasswordRequest, (String)"'changePasswordRequest' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/change_password", changePasswordRequest, this, UserCredentials.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public AppLinkList listAppLinks(Boolean showAll) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (showAll != null) {
            queryArgs.put("showAll", showAll);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/appLinks", AppLinkList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AppLinkList listAppLinks() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/appLinks", AppLinkList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void addGroupTargetToRole(String roleId, String groupId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups/" + groupId + "";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()), this, queryArgs, (Map<String, List<String>>)headers);
    }

    public SecurityQuestionList listSupportedSecurityQuestions() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors/questions", SecurityQuestionList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void endAllSessions(Boolean oAuthTokens) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (oAuthTokens != null) {
            queryArgs.put("oauthTokens", oAuthTokens);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/sessions", queryArgs, (Map<String, List<String>>)headers);
    }

    public void endAllSessions() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/sessions", queryArgs, (Map<String, List<String>>)headers);
    }

    public void addToGroup(String groupId) {
        String userId = this.getId();
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/" + groupId + "/users/" + userId + "";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()), this, queryArgs, (Map<String, List<String>>)headers);
    }

    public Role addRole(Role role) {
        String userId = this.getId();
        Assert.notNull((Object)role, (String)"'role' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/roles", role, this, Role.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return role;
    }

    public Factor addFactor(Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate, Factor body) {
        return this.addFactor(body, updatePhone, templateId, tokenLifetimeSeconds, activate);
    }

    public Factor addFactor(Boolean updatePhone, String templateId, Factor body) {
        return this.addFactor(body, updatePhone, templateId);
    }

    public ForgotPasswordResponse forgotPassword(Boolean sendEmail, UserCredentials userCredentials) {
        return this.forgotPassword(userCredentials, sendEmail);
    }
}

