/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.client;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.impl.client.AbstractClient;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.group.rule.GroupRuleList;
import com.okta.sdk.resource.log.LogEventList;
import com.okta.sdk.resource.policy.Policy;
import com.okta.sdk.resource.policy.PolicyList;
import com.okta.sdk.resource.session.CreateSessionRequest;
import com.okta.sdk.resource.session.Session;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserList;
import com.okta.sdk.resource.user.UserNextLogin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultClient
extends AbstractClient {
    public DefaultClient(ClientConfiguration clientConfiguration, CacheManager cacheManager) {
        super(clientConfiguration, cacheManager);
    }

    public ApplicationList listApplications(String q, String filter, String expand, Boolean includeNonDeleted) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        if (includeNonDeleted != null) {
            queryArgs.put("includeNonDeleted", includeNonDeleted);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps", ApplicationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationList listApplications() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps", ApplicationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Application createApplication(Application application, Boolean activate) {
        Assert.notNull((Object)application, (String)"'application' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps", application, null, Application.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return application;
    }

    public Application createApplication(Application application) {
        Assert.notNull((Object)application, (String)"'application' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps", application, null, Application.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return application;
    }

    public Application getApplication(String appId, String expand) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "", Application.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Application getApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "", Application.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listGroups(String q, String filter, String expand) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listGroups() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Group createGroup(Group group) {
        Assert.notNull((Object)group, (String)"'group' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/groups", group, null, Group.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return group;
    }

    public GroupRuleList listRules(String expand) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/rules", GroupRuleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupRuleList listRules() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/rules", GroupRuleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupRule createRule(GroupRule groupRule) {
        Assert.notNull((Object)groupRule, (String)"'groupRule' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/groups/rules", groupRule, null, GroupRule.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return groupRule;
    }

    public GroupRule getRule(String ruleId, String expand) {
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/rules/" + ruleId + "", GroupRule.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupRule getRule(String ruleId) {
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/rules/" + ruleId + "", GroupRule.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Group getGroup(String groupId, String expand) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "", Group.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Group getGroup(String groupId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "", Group.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public LogEventList getLogs(String until, String since, String filter, String q, String sortOrder) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (until != null) {
            queryArgs.put("until", until);
        }
        if (since != null) {
            queryArgs.put("since", since);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (sortOrder != null) {
            queryArgs.put("sortOrder", sortOrder);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/logs", LogEventList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public LogEventList getLogs() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/logs", LogEventList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyList listPolicies(String type, String status, String expand) {
        Assert.notNull((Object)type, (String)"'type' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (type != null) {
            queryArgs.put("type", type);
        }
        if (status != null) {
            queryArgs.put("status", status);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies", PolicyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyList listPolicies(String type) {
        Assert.notNull((Object)type, (String)"'type' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        queryArgs.put("type", type);
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies", PolicyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Policy createPolicy(Policy policy, Boolean activate) {
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies", policy, null, Policy.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policy;
    }

    public Policy createPolicy(Policy policy) {
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies", policy, null, Policy.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policy;
    }

    public Policy getPolicy(String policyId, String expand) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies/" + policyId + "", Policy.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Policy getPolicy(String policyId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies/" + policyId + "", Policy.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Session createSession(CreateSessionRequest createSessionRequest) {
        Assert.notNull((Object)createSessionRequest, (String)"'createSessionRequest' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/sessions", createSessionRequest, null, Session.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public Session getSession(String sessionId) {
        Assert.hasText((String)sessionId, (String)"'sessionId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/sessions/" + sessionId + "", Session.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserList listUsers(String q, String filter, String format, String search, String expand) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (format != null) {
            queryArgs.put("format", format);
        }
        if (search != null) {
            queryArgs.put("search", search);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users", UserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserList listUsers() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users", UserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public User createUser(User body, Boolean activate, Boolean provider, UserNextLogin nextLogin) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        if (provider != null) {
            queryArgs.put("provider", provider);
        }
        if (nextLogin != null) {
            queryArgs.put("nextLogin", nextLogin);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users", body, null, User.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public User createUser(User body) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users", body, null, User.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public User createUser(User body, Boolean activate, Boolean provider) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        if (provider != null) {
            queryArgs.put("provider", provider);
        }
        this.getDataStore().create("/api/v1/users", body, null, User.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public User getUser(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "", User.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

