/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.ResourceAction;
import com.okta.sdk.impl.ds.ResourceMessage;
import com.okta.sdk.impl.http.CanonicalUri;
import com.okta.sdk.impl.http.HttpHeaders;
import com.okta.sdk.resource.Resource;
import java.util.Map;

public class DefaultResourceMessage
implements ResourceMessage {
    private final ResourceAction action;
    private final CanonicalUri uri;
    private final Class<? extends Resource> resourceClass;
    private final Map<String, Object> data;
    private HttpHeaders httpHeaders;

    public DefaultResourceMessage(ResourceAction action, CanonicalUri uri, Class<? extends Resource> resourceClass, Map<String, Object> data) {
        Assert.notNull((Object)((Object)action), (String)"resource action cannot be null.");
        Assert.notNull((Object)uri, (String)"uri cannot be null.");
        Assert.notNull(resourceClass, (String)"resourceClass cannot be null.");
        Assert.notNull(data, (String)"data map cannot be null - specify an empty map instead of null.");
        this.action = action;
        this.uri = uri;
        this.resourceClass = resourceClass;
        this.data = data;
    }

    public DefaultResourceMessage(ResourceAction action, CanonicalUri uri, Class<? extends Resource> resourceClass, Map<String, Object> data, HttpHeaders customHeaders) {
        this(action, uri, resourceClass, data);
        this.httpHeaders = customHeaders;
    }

    @Override
    public CanonicalUri getUri() {
        return this.uri;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return this.resourceClass;
    }

    @Override
    public Map<String, Object> getData() {
        return this.data;
    }

    @Override
    public ResourceAction getAction() {
        return this.action;
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders != null ? this.httpHeaders : new HttpHeaders();
    }
}

