/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.okta.commons.lang.Collections;
import com.okta.sdk.ds.RequestBuilder;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import java.util.HashMap;
import java.util.Map;

class DefaultRequestBuilder
implements RequestBuilder {
    private final InternalDataStore dataStore;
    private Resource body;
    private Map<String, Object> queryParams = new HashMap<String, Object>();

    DefaultRequestBuilder(InternalDataStore dataStore) {
        this.dataStore = dataStore;
        this.body = dataStore.instantiate(VoidResource.class);
    }

    public RequestBuilder setBody(Resource resource) {
        this.body = resource;
        return this;
    }

    public RequestBuilder addQueryParameter(String key, String value) {
        this.queryParams.put(key, value);
        return this;
    }

    public RequestBuilder setQueryParameters(Map<String, String> queryParams) {
        this.queryParams.clear();
        if (!Collections.isEmpty(queryParams)) {
            this.queryParams.putAll(queryParams);
        }
        return this;
    }

    public <T extends Resource> T get(String href, Class<T> type) {
        return this.dataStore.getResource(href, type, this.queryParams);
    }

    public void put(String href) {
        this.dataStore.save(href, this.body, null, this.queryParams);
    }

    public <T extends Resource> T post(String href, Class<T> type) {
        return this.dataStore.create(href, this.body, null, type, this.queryParams);
    }

    public void delete(String href) {
        this.dataStore.delete(href, this.queryParams);
    }

    Resource getBody() {
        return this.body;
    }

    Map<String, Object> getQueryParameters() {
        return java.util.Collections.unmodifiableMap(this.queryParams);
    }
}

