/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.http.support;

import com.okta.commons.lang.Strings;
import com.okta.sdk.http.HttpMethod;
import com.okta.sdk.impl.http.HttpHeaders;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.http.Request;
import com.okta.sdk.impl.http.support.AbstractHttpMessage;
import java.io.InputStream;
import java.net.URI;

public class DefaultRequest
extends AbstractHttpMessage
implements Request {
    private final HttpMethod method;
    private final URI resourceUrl;
    private final HttpHeaders headers;
    private final QueryString queryString;
    private final InputStream body;

    public DefaultRequest(HttpMethod method, String href) {
        this(method, href, null, null, null, -1L);
    }

    public DefaultRequest(HttpMethod method, String href, QueryString query) {
        this(method, href, query, null);
    }

    public DefaultRequest(HttpMethod method, String href, QueryString query, HttpHeaders headers) {
        this(method, href, query, headers, null, -1L);
    }

    public DefaultRequest(HttpMethod method, String href, QueryString query, HttpHeaders headers, InputStream body, long contentLength) {
        this.method = method;
        String[] split = Strings.split((String)href, (String)"?");
        if (split != null) {
            this.resourceUrl = URI.create(split[0]);
            this.queryString = QueryString.create(split[1]);
            if (query != null && !query.isEmpty()) {
                this.queryString.putAll(query);
            }
        } else {
            this.resourceUrl = URI.create(href);
            this.queryString = query != null ? query : new QueryString();
        }
        this.headers = headers != null ? headers : new HttpHeaders();
        this.body = body;
        this.headers.setContentLength(contentLength);
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public URI getResourceUrl() {
        return this.resourceUrl;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(HttpHeaders headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    @Override
    public QueryString getQueryString() {
        return this.queryString;
    }

    @Override
    public void setQueryString(QueryString queryString) {
        this.queryString.clear();
        this.queryString.putAll(queryString);
    }

    @Override
    public InputStream getBody() {
        return this.body;
    }
}

