/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.user.factor;

import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.user.factor.Factor;
import com.okta.sdk.resource.user.factor.FactorProfile;
import com.okta.sdk.resource.user.factor.FactorProvider;
import com.okta.sdk.resource.user.factor.FactorStatus;
import com.okta.sdk.resource.user.factor.FactorType;
import com.okta.sdk.resource.user.factor.VerifyFactorRequest;
import com.okta.sdk.resource.user.factor.VerifyFactorResponse;
import java.util.Map;

public class DefaultFactor
extends AbstractInstanceResource<Factor>
implements Factor {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final StringProperty deviceProperty = new StringProperty("device");
    private static final StringProperty deviceTypeProperty = new StringProperty("deviceType");
    private static final EnumProperty<FactorType> factorTypeProperty = new EnumProperty<FactorType>("factorType", FactorType.class);
    private static final StringProperty idProperty = new StringProperty("id");
    private static final StringProperty mfaStateTokenIdProperty = new StringProperty("mfaStateTokenId");
    private static final ResourceReference<FactorProfile> profileProperty = new ResourceReference<FactorProfile>("profile", FactorProfile.class, true);
    private static final EnumProperty<FactorProvider> providerProperty = new EnumProperty<FactorProvider>("provider", FactorProvider.class);
    private static final BooleanProperty rechallengeExistingFactorProperty = new BooleanProperty("rechallengeExistingFactor");
    private static final StringProperty sessionIdProperty = new StringProperty("sessionId");
    private static final EnumProperty<FactorStatus> statusProperty = new EnumProperty<FactorStatus>("status", FactorStatus.class);
    private static final IntegerProperty tokenLifetimeSecondsProperty = new IntegerProperty("tokenLifetimeSeconds");
    private static final StringProperty userIdProperty = new StringProperty("userId");
    private static final ResourceReference<VerifyFactorRequest> verifyProperty = new ResourceReference<VerifyFactorRequest>("verify", VerifyFactorRequest.class, false);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultFactor.createPropertyDescriptorMap(embeddedProperty, linksProperty, deviceProperty, deviceTypeProperty, factorTypeProperty, idProperty, mfaStateTokenIdProperty, profileProperty, providerProperty, rechallengeExistingFactorProperty, sessionIdProperty, statusProperty, tokenLifetimeSecondsProperty, userIdProperty, verifyProperty);

    public DefaultFactor(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultFactor(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Factor.class;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public String getDevice() {
        return this.getString(deviceProperty);
    }

    public Factor setDevice(String device) {
        this.setProperty(deviceProperty, (Object)device);
        return this;
    }

    public String getDeviceType() {
        return this.getString(deviceTypeProperty);
    }

    public FactorType getFactorType() {
        return this.getEnumProperty(factorTypeProperty);
    }

    public Factor setFactorType(FactorType factorType) {
        this.setProperty(factorTypeProperty, (Object)factorType);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public String getMfaStateTokenId() {
        return this.getString(mfaStateTokenIdProperty);
    }

    public Factor setMfaStateTokenId(String mfaStateTokenId) {
        this.setProperty(mfaStateTokenIdProperty, (Object)mfaStateTokenId);
        return this;
    }

    public FactorProfile getProfile() {
        return this.getResourceProperty(profileProperty);
    }

    public Factor setProfile(FactorProfile profile) {
        this.setProperty(profileProperty, (Object)profile);
        return this;
    }

    public FactorProvider getProvider() {
        return this.getEnumProperty(providerProperty);
    }

    public Factor setProvider(FactorProvider provider) {
        this.setProperty(providerProperty, (Object)provider);
        return this;
    }

    public Boolean getRechallengeExistingFactor() {
        return this.getBoolean(rechallengeExistingFactorProperty);
    }

    public Factor setRechallengeExistingFactor(Boolean rechallengeExistingFactor) {
        this.setProperty(rechallengeExistingFactorProperty, (Object)rechallengeExistingFactor);
        return this;
    }

    public String getSessionId() {
        return this.getString(sessionIdProperty);
    }

    public Factor setSessionId(String sessionId) {
        this.setProperty(sessionIdProperty, (Object)sessionId);
        return this;
    }

    public FactorStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public Integer getTokenLifetimeSeconds() {
        return this.getIntProperty(tokenLifetimeSecondsProperty);
    }

    public Factor setTokenLifetimeSeconds(Integer tokenLifetimeSeconds) {
        this.setProperty(tokenLifetimeSecondsProperty, (Object)tokenLifetimeSeconds);
        return this;
    }

    public String getUserId() {
        return this.getString(userIdProperty);
    }

    public Factor setUserId(String userId) {
        this.setProperty(userIdProperty, (Object)userId);
        return this;
    }

    public VerifyFactorRequest getVerify() {
        return this.getResourceProperty(verifyProperty);
    }

    public Factor setVerify(VerifyFactorRequest verify) {
        this.setProperty(verifyProperty, (Object)verify);
        return this;
    }

    @Override
    public void delete() {
        String factorId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}");
        String userId = pathArgs.get("userId");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/factors/" + factorId + "";
        this.getDataStore().delete(href, this);
    }

    public Factor activate(VerifyFactorRequest body) {
        String factorId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate");
        String userId = pathArgs.get("userId");
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/factors/" + factorId + "/lifecycle/activate";
        return this.getDataStore().create(href, body, this, Factor.class);
    }

    public VerifyFactorResponse verify(VerifyFactorRequest body, String templateId, Integer tokenLifetimeSeconds) {
        String factorId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/verify");
        String userId = pathArgs.get("userId");
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (templateId != null) {
            queryArgs.put("templateId", templateId);
        }
        if (tokenLifetimeSeconds != null) {
            queryArgs.put("tokenLifetimeSeconds", tokenLifetimeSeconds);
        }
        String href = QueryString.buildHref("/api/v1/users/" + userId + "/factors/" + factorId + "/verify", queryArgs);
        return this.getDataStore().create(href, body, this, VerifyFactorResponse.class);
    }

    public VerifyFactorResponse verify(VerifyFactorRequest body) {
        String factorId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/verify");
        String userId = pathArgs.get("userId");
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        String href = QueryString.buildHref("/api/v1/users/" + userId + "/factors/" + factorId + "/verify", queryArgs);
        return this.getDataStore().create(href, body, this, VerifyFactorResponse.class);
    }

    public VerifyFactorResponse verify(VerifyFactorRequest body, String templateId) {
        String factorId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/verify");
        String userId = pathArgs.get("userId");
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (body != null) {
            queryArgs.put("body", body);
        }
        if (templateId != null) {
            queryArgs.put("templateId", templateId);
        }
        String href = QueryString.buildHref("/api/v1/users/" + userId + "/factors/" + factorId + "/verify", queryArgs);
        return this.getDataStore().create(href, body, null, VerifyFactorResponse.class);
    }

    public VerifyFactorResponse verify(String templateId, VerifyFactorRequest body) {
        return this.verify(body, templateId);
    }

    public VerifyFactorResponse verify(String templateId, Integer tokenLifetimeSeconds, VerifyFactorRequest body) {
        return this.verify(body, templateId, tokenLifetimeSeconds);
    }
}

