/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds.cache;

import com.okta.sdk.cache.Cache;
import com.okta.sdk.impl.ds.CacheMapInitializer;
import com.okta.sdk.impl.ds.DefaultCacheMapInitializer;
import com.okta.sdk.impl.ds.DefaultResourceDataResult;
import com.okta.sdk.impl.ds.ResourceAction;
import com.okta.sdk.impl.ds.ResourceDataRequest;
import com.okta.sdk.impl.ds.ResourceDataResult;
import com.okta.sdk.impl.ds.cache.CacheResolver;
import com.okta.sdk.impl.ds.cache.ResourceCacheStrategy;
import com.okta.sdk.impl.http.CanonicalUri;
import com.okta.sdk.impl.resource.ResourceHrefResolver;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Collections;
import com.okta.sdk.resource.CollectionResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceCacheStrategy
implements ResourceCacheStrategy {
    private final Logger logger = LoggerFactory.getLogger(DefaultResourceCacheStrategy.class);
    private final ResourceHrefResolver hrefResolver;
    private final CacheResolver cacheResolver;
    private final CacheMapInitializer cacheMapInitializer = new DefaultCacheMapInitializer();

    public DefaultResourceCacheStrategy(ResourceHrefResolver hrefResolver, CacheResolver cacheResolver) {
        this.hrefResolver = hrefResolver;
        this.cacheResolver = cacheResolver;
    }

    @Override
    public void cache(ResourceDataRequest request, ResourceDataResult result) {
        if (request.getAction() == ResourceAction.DELETE) {
            String key = this.getCacheKey(request);
            this.uncache(key, request.getResourceClass());
        } else if (this.isCacheable(result)) {
            this.cache(result.getResourceClass(), result.getData(), result.getUri());
        } else if (request.getParentUri() != null) {
            this.logger.debug("Removing parent cache  '{}'", (Object)request.getUri().getAbsolutePath());
            String key = this.getCacheKey(request.getParentUri().getAbsolutePath());
            this.uncache(key, request.getParentResourceClass());
        } else {
            this.logger.debug("Cannot cache action: '{}', href: '{}', class: '{}'", new Object[]{result.getAction(), result.getUri().getAbsolutePath(), result.getResourceClass()});
        }
    }

    @Override
    public ResourceDataResult readFromCache(ResourceDataRequest request) {
        if (!this.isCacheRetrievalEnabled(request)) {
            return null;
        }
        CanonicalUri uri = request.getUri();
        Class<? extends Resource> clazz = request.getResourceClass();
        Map<String, ?> data = null;
        String cacheKey = this.getCacheKey(request);
        if (!request.getUri().hasQuery() || !(request.getUri().getQuery().containsKey("expand") ^ (cacheKey != null && cacheKey.contains("expand=")))) {
            data = this.getCachedValue(cacheKey, clazz);
        }
        if (Collections.isEmpty(data)) {
            return null;
        }
        return new DefaultResourceDataResult(request.getAction(), uri, clazz, DefaultResourceCacheStrategy.coerce(data));
    }

    private void cache(Class<? extends Resource> clazz, Map<String, ?> data, CanonicalUri uri) {
        Assert.notEmpty(data, (String)"Resource data cannot be null or empty.");
        String href = this.hrefResolver.resolveHref(data, clazz);
        if (this.isDirectlyCacheable(clazz, data)) {
            Assert.notNull((Object)href, (String)"Resource data must contain an 'href' attribute.");
            Assert.isTrue((data.size() > 0 ? 1 : 0) != 0, (String)"Resource data must be materialized to be cached (need more at least one attribute).");
        }
        Map<String, Object> cacheValue = this.cacheMapInitializer.initialize(clazz, data, uri.getQuery());
        data.entrySet().forEach(entry -> cacheValue.put((String)entry.getKey(), entry.getValue()));
        if (this.isDirectlyCacheable(clazz, cacheValue)) {
            Cache<String, Map<String, ?>> cache = this.getCache(clazz);
            String cacheKey = this.getCacheKey(href);
            Object previousCacheValue = cache.put((Object)cacheKey, cacheValue);
            this.logger.debug("Caching object for key '{}', class: '{}', updated {}", new Object[]{cacheKey, clazz, previousCacheValue != null});
        }
    }

    private void uncache(String cacheKey, Class<? extends Resource> resourceType) {
        Assert.hasText((String)cacheKey, (String)"cacheKey cannot be null or empty.");
        Assert.notNull(resourceType, (String)"resourceType cannot be null.");
        Cache<String, Map<String, ?>> cache = this.getCache(resourceType);
        cache.remove((Object)cacheKey);
        this.logger.debug("Removing cache for key '{}', class: '{}'", (Object)cacheKey, resourceType);
    }

    private boolean isCacheable(ResourceDataResult result) {
        if (Collections.isEmpty(result.getData())) {
            return false;
        }
        Class<? extends Resource> clazz = result.getResourceClass();
        boolean materialized = this.isMaterialized(result.getData(), clazz);
        if (!materialized) {
            this.logger.debug("Class: {}, is not cacheable.", (Object)clazz.getSimpleName());
        }
        return materialized;
    }

    private boolean isDirectlyCacheable(Class<? extends Resource> clazz, Map<String, ?> data) {
        return this.isMaterialized(data, clazz) && !CollectionResource.class.isAssignableFrom(clazz);
    }

    private boolean isCacheRetrievalEnabled(ResourceDataRequest request) {
        return request.getAction() == ResourceAction.READ && !CollectionResource.class.isAssignableFrom(request.getResourceClass());
    }

    private <R extends Resource> boolean isMaterialized(Map<String, ?> props, Class<R> clazz) {
        return this.hrefResolver.resolveHref(props, clazz) != null;
    }

    private <T> Cache<String, Map<String, ?>> getCache(Class<T> clazz) {
        return this.cacheResolver.getCache(clazz);
    }

    private Map<String, ?> getCachedValue(String href, Class<? extends Resource> clazz) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        Assert.notNull(clazz, (String)"Class argument cannot be null.");
        Cache<String, Map<String, ?>> cache = this.getCache(clazz);
        Map value = (Map)cache.get((Object)href);
        if (value != null) {
            this.logger.debug("Cache hit for key      '{}', class: '{}'", (Object)href, clazz);
        }
        return value;
    }

    private String getCacheKey(ResourceDataRequest request) {
        return this.getCacheKey(request.getUri().getAbsolutePath());
    }

    private String getCacheKey(String href) {
        return href;
    }

    private static Map<String, Object> coerce(Map<String, ?> data) {
        return data;
    }
}

