/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.client;

import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.Proxy;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.client.AbstractClient;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.okta.sdk.impl.util.BaseUrlResolver;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.group.rule.GroupRuleList;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserList;

public class DefaultClient
extends AbstractClient {
    public DefaultClient(ClientCredentialsResolver clientCredentialsResolver, BaseUrlResolver baseUrlResolver, Proxy proxy, CacheManager cacheManager, AuthenticationScheme authenticationScheme, RequestAuthenticatorFactory requestAuthenticatorFactory, int connectionTimeout) {
        super(clientCredentialsResolver, baseUrlResolver, proxy, cacheManager, authenticationScheme, requestAuthenticatorFactory, connectionTimeout);
    }

    public Application createApplication(Application application, Boolean activate) {
        QueryString queryArgs = new QueryString();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        String href = QueryString.buildHref("/api/v1/apps", queryArgs);
        this.getDataStore().create(href, application, application.getClass());
        return application;
    }

    public Application createApplication(Application application) {
        String href = "/api/v1/apps";
        this.getDataStore().create(href, application, application.getClass());
        return application;
    }

    public Group createGroup(Group group) {
        String href = "/api/v1/groups";
        this.getDataStore().create(href, group, group.getClass());
        return group;
    }

    public GroupRule createRule(GroupRule groupRule) {
        String href = "/api/v1/groups/rules";
        this.getDataStore().create(href, groupRule, groupRule.getClass());
        return groupRule;
    }

    public User createUser(User body, Boolean activate, Boolean provider) {
        QueryString queryArgs = new QueryString();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        if (provider != null) {
            queryArgs.put("provider", provider);
        }
        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        this.getDataStore().create(href, body, body.getClass());
        return body;
    }

    public User createUser(User body) {
        String href = "/api/v1/users";
        this.getDataStore().create(href, body, body.getClass());
        return body;
    }

    public Application getApplication(String appId, String expand) {
        QueryString queryArgs = new QueryString();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/apps/" + appId + "", queryArgs);
        return (Application)this.getDataStore().getResource(href, Application.class);
    }

    public Application getApplication(String appId) {
        String href = "/api/v1/apps/" + appId + "";
        return (Application)this.getDataStore().getResource(href, Application.class);
    }

    public Group getGroup(String groupId, String expand) {
        QueryString queryArgs = new QueryString();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/groups/" + groupId + "", queryArgs);
        return (Group)this.getDataStore().getResource(href, Group.class);
    }

    public Group getGroup(String groupId) {
        String href = "/api/v1/groups/" + groupId + "";
        return (Group)this.getDataStore().getResource(href, Group.class);
    }

    public GroupRule getRule(String ruleId) {
        String href = "/api/v1/groups/rules/" + ruleId + "";
        return (GroupRule)this.getDataStore().getResource(href, GroupRule.class);
    }

    public User getUser(String userId) {
        String href = "/api/v1/users/" + userId + "";
        return (User)this.getDataStore().getResource(href, User.class);
    }

    public ApplicationList listApplications(String q, String filter, String expand, Boolean includeNonDeleted) {
        QueryString queryArgs = new QueryString();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        if (includeNonDeleted != null) {
            queryArgs.put("includeNonDeleted", includeNonDeleted);
        }
        String href = QueryString.buildHref("/api/v1/apps", queryArgs);
        return (ApplicationList)this.getDataStore().getResource(href, ApplicationList.class);
    }

    public ApplicationList listApplications() {
        String href = "/api/v1/apps";
        return (ApplicationList)this.getDataStore().getResource(href, ApplicationList.class);
    }

    public GroupList listGroups(String q, String filter, String expand) {
        QueryString queryArgs = new QueryString();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/groups", queryArgs);
        return (GroupList)this.getDataStore().getResource(href, GroupList.class);
    }

    public GroupList listGroups() {
        String href = "/api/v1/groups";
        return (GroupList)this.getDataStore().getResource(href, GroupList.class);
    }

    public GroupRuleList listRules() {
        String href = "/api/v1/groups/rules";
        return (GroupRuleList)this.getDataStore().getResource(href, GroupRuleList.class);
    }

    public UserList listUsers(String q, String filter, String format, String search, String expand) {
        QueryString queryArgs = new QueryString();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (format != null) {
            queryArgs.put("format", format);
        }
        if (search != null) {
            queryArgs.put("search", search);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        return (UserList)this.getDataStore().getResource(href, UserList.class);
    }

    public UserList listUsers() {
        String href = "/api/v1/users";
        return (UserList)this.getDataStore().getResource(href, UserList.class);
    }
}

