/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.query;

import com.okta.sdk.impl.query.Expandable;
import com.okta.sdk.impl.query.Expansion;
import com.okta.sdk.impl.query.Order;
import com.okta.sdk.impl.query.Pagination;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Strings;
import com.okta.sdk.query.Criteria;
import com.okta.sdk.query.Criterion;
import com.okta.sdk.query.Options;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultCriteria<T extends Criteria<T>, O extends Options>
implements Criteria<T>,
Expandable {
    protected final List<Criterion> criterionEntries;
    protected final List<Order> orderEntries;
    protected final O options;
    protected Integer limit;
    protected Integer offset;
    private Map<String, String> customAttributes;
    protected int currentOrderIndex = -1;

    protected DefaultCriteria(O options) {
        Assert.notNull(options, (String)"options argument cannot be null.");
        Assert.isInstanceOf(Expandable.class, options, (String)("options argument is expected to implement the " + Expandable.class.getName() + " interface."));
        this.options = options;
        this.criterionEntries = new ArrayList<Criterion>();
        this.orderEntries = new ArrayList<Order>();
        this.customAttributes = new HashMap<String, String>();
    }

    public T add(Criterion criterion) {
        Assert.notNull((Object)criterion, (String)"criterion cannot be null.");
        this.criterionEntries.add(criterion);
        return (T)this;
    }

    public T and(Criterion criterion) {
        return this.add(criterion);
    }

    public T add(Order order) {
        Assert.notNull((Object)order, (String)"order cannot be null.");
        this.orderEntries.add(order);
        this.currentOrderIndex = this.orderEntries.size() - 1;
        return (T)this;
    }

    public T orderBy(Property property) {
        Order order = Order.asc(property.getName());
        return this.add(order);
    }

    private int ensureOrderIndex() {
        int i = this.currentOrderIndex;
        Assert.state((i >= 0 ? 1 : 0) != 0, (String)"There is no current orderBy clause to declare as ascending or descending!");
        return i;
    }

    @Override
    public List<Expansion> getExpansions() {
        assert (this.options instanceof Expandable);
        return ((Expandable)this.options).getExpansions();
    }

    public T ascending() {
        return this.orderDirection(true);
    }

    public T descending() {
        return this.orderDirection(false);
    }

    private T orderDirection(boolean ascending) {
        int i = this.ensureOrderIndex();
        Order order = this.orderEntries.get(i);
        if (order.isAscending() != ascending) {
            String name = order.getPropertyName();
            Order newOrder = ascending ? Order.asc(name) : Order.desc(name);
            this.orderEntries.set(i, newOrder);
        }
        return (T)this;
    }

    public List<Criterion> getCriterionEntries() {
        return Collections.unmodifiableList(this.criterionEntries);
    }

    public List<Order> getOrderEntries() {
        return Collections.unmodifiableList(this.orderEntries);
    }

    protected O getOptions() {
        return this.options;
    }

    public T limitTo(int limit) {
        this.limit = Pagination.sanitizeLimit(limit);
        return (T)this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public T offsetBy(int offset) {
        this.offset = Pagination.sanitizeOffset(offset);
        return (T)this;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public boolean isEmpty() {
        return !(!this.options.isEmpty() || !this.criterionEntries.isEmpty() || !this.orderEntries.isEmpty() || this.offset != null && this.offset != 0 || this.limit != null && this.limit != 0);
    }

    public boolean hasCustomAttributes() {
        return !this.customAttributes.isEmpty();
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        for (Criterion c : this.criterionEntries) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(c);
        }
        if (!this.orderEntries.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("order by ").append(Strings.collectionToDelimitedString(this.orderEntries, (String)", "));
        }
        if (this.offset != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("offset ").append(this.offset);
        }
        if (this.limit != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("limit ").append(this.limit);
        }
        if (!this.options.isEmpty() && this.options instanceof Expandable) {
            Expandable expandable = (Expandable)this.options;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("expand ").append(Strings.collectionToDelimitedString(expandable.getExpansions(), (String)", "));
        }
        if (this.hasCustomAttributes()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("custom attributes: ").append(this.getCustomAttributes().toString());
        }
        return sb.toString();
    }
}

