/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.error;

import com.okta.sdk.error.Error;
import com.okta.sdk.impl.error.DefaultError;
import com.okta.sdk.lang.Assert;
import java.util.HashMap;
import java.util.Map;

public class DefaultErrorBuilder {
    private final Map<String, Object> errorProperties;

    public DefaultErrorBuilder(int status) {
        Assert.notNull((Object)status, (String)"status cannot be null.");
        this.errorProperties = new HashMap<String, Object>();
        this.errorProperties.put(DefaultError.STATUS.getName(), status);
    }

    public static DefaultErrorBuilder status(Integer status) {
        return new DefaultErrorBuilder(status);
    }

    public DefaultErrorBuilder code(String code) {
        this.errorProperties.put(DefaultError.CODE.getName(), code);
        return this;
    }

    public DefaultErrorBuilder message(String message) {
        this.errorProperties.put(DefaultError.MESSAGE.getName(), message);
        return this;
    }

    public DefaultErrorBuilder causes(Map<String, String> causes) {
        this.errorProperties.put(DefaultError.CAUSES.getName(), causes);
        return this;
    }

    public DefaultErrorBuilder errorId(String requestId) {
        this.errorProperties.put(DefaultError.ERROR_ID.getName(), requestId);
        return this;
    }

    public DefaultErrorBuilder headers(Map<String, String[]> headers) {
        this.errorProperties.put(DefaultError.HEADERS.getName(), headers);
        return this;
    }

    public Error build() {
        for (Object value : this.errorProperties.values()) {
            Assert.notNull((Object)value);
        }
        return new DefaultError(this.errorProperties);
    }
}

