/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.okta.sdk.impl.ds.Enlistment;
import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.ParentAwareObjectProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Classes;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertyRetriever {
    private static final Logger log = LoggerFactory.getLogger(AbstractPropertyRetriever.class);
    private final DateFormat dateFormatter = new ISO8601DateFormat();
    protected final Lock readLock;
    protected final Lock writeLock;

    protected AbstractPropertyRetriever() {
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.readLock = rwl.readLock();
        this.writeLock = rwl.writeLock();
    }

    public abstract Object getProperty(String var1);

    protected String getString(StringProperty property) {
        return this.getStringProperty(property.getName());
    }

    protected String getStringProperty(String key) {
        Object value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    protected int getInt(IntegerProperty property) {
        return this.getIntProperty(property.getName());
    }

    protected int getIntProperty(String key) {
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof String) {
                return this.parseInt((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
        }
        return -1;
    }

    protected boolean getBoolean(BooleanProperty property) {
        return this.getBooleanProperty(property.getName());
    }

    protected boolean getBooleanProperty(String key) {
        return Boolean.TRUE.equals(this.getNullableBooleanProperty(key));
    }

    protected Boolean getNullableBoolean(BooleanProperty property) {
        return this.getNullableBooleanProperty(property.getName());
    }

    protected Boolean getNullableBooleanProperty(String key) {
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
        }
        return null;
    }

    private int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            if (log.isErrorEnabled()) {
                String msg = "Unabled to parse string '{}' into an integer value.  Defaulting to -1";
                log.error(msg, (Throwable)e);
            }
            return -1;
        }
    }

    protected Date getDateProperty(DateProperty key) {
        Object value = this.getProperty(key.getName());
        if (value == null) {
            return null;
        }
        try {
            return this.dateFormatter.parse(String.valueOf(value));
        }
        catch (ParseException e) {
            if (log.isErrorEnabled()) {
                String msg = "Unabled to parse string '{}' into an date value.  Defaulting to null.";
                log.error(msg, (Throwable)e);
            }
            return null;
        }
    }

    protected List getListProperty(String key) {
        Object list = this.getProperty(key);
        return (List)list;
    }

    protected Set getSetProperty(String key) {
        Object set = this.getProperty(key);
        return (Set)set;
    }

    protected Map getMap(MapProperty mapProperty) {
        return this.getMapProperty(mapProperty.getName());
    }

    protected Map getMapProperty(String key) {
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof Map) {
                return (Map)value;
            }
            String msg = "'" + key + "' property value type does not match the specified type. Specified type: Map. Existing type: " + value.getClass().getName();
            msg = msg + (this.isPrintableProperty(key) ? ".  Value: " + value : ".");
            throw new IllegalArgumentException(msg);
        }
        return null;
    }

    protected <E extends Enum<E>> E getEnumProperty(EnumProperty<E> enumProperty) {
        return (E)this.getEnumProperty(enumProperty.getName(), enumProperty.getType());
    }

    protected <E extends Enum<E>> E getEnumProperty(String key, Class<E> type) {
        Assert.notNull(type, (String)"type cannot be null.");
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof String) {
                return Enum.valueOf(type, value.toString());
            }
            if (type.isAssignableFrom(value.getClass())) {
                return (E)((Enum)value);
            }
        }
        return null;
    }

    protected <T, P> T getParentAwareObjectProperty(ParentAwareObjectProperty<T, P> objectProperty) {
        return this.getParentAwareObjectProperty(objectProperty.getName(), objectProperty.getType(), objectProperty.getParentType());
    }

    protected <T, P> T getParentAwareObjectProperty(String name, Class<T> type, Class<P> parentType) {
        Object value = this.getProperty(name);
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (value instanceof Map) {
            this.writeLock.lock();
            try {
                Constructor propertyConstructor = Classes.getConstructor(type, (Class[])new Class[]{String.class, Map.class, parentType});
                Object instance = propertyConstructor.newInstance(name, new Enlistment((Map)value), this);
                this.getInternalProperties().put(name, instance);
                Object t = instance;
                return t;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create instace", e);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        String msg = "'" + name + "' property value type does not match the specified property type. Existing type: " + value.getClass().getName();
        msg = msg + (this.isPrintableProperty(name) ? ".  Value: " + value : ".");
        throw new IllegalArgumentException(msg);
    }

    protected boolean isPrintableProperty(String name) {
        return true;
    }

    protected void setProperty(Property property, Object value) {
        this.setProperty(property.getName(), value, true);
    }

    public void setProperty(String name, Object value) {
        this.setProperty(name, value, true);
    }

    protected abstract Object setProperty(String var1, Object var2, boolean var3);

    protected abstract Map<String, Object> getInternalProperties();
}

