/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.query;

import com.okta.sdk.impl.query.Operator;
import com.okta.sdk.impl.query.SimpleExpression;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Duration;
import com.okta.sdk.query.Criterion;
import com.okta.sdk.query.DateExpressionFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class DefaultDateExpressionFactory
implements DateExpressionFactory {
    private final String propertyName;
    private static final String INCLUSIVE_OPENING = "[";
    private static final String INCLUSIVE_CLOSING = "]";
    private static final String EXCLUSIVE_OPENING = "(";
    private static final String EXCLUSIVE_CLOSING = ")";
    private static final String COMMA = ", ";

    public DefaultDateExpressionFactory(String propertyName) {
        this.propertyName = propertyName;
    }

    public SimpleExpression matches(String value) {
        return new SimpleExpression(this.propertyName, value, Operator.EQUALS);
    }

    public Criterion gt(Date date) {
        Assert.notNull((Object)date, (String)"date needs to be a valid Date object");
        DateTime dateTime = new DateTime((Object)date);
        String value = EXCLUSIVE_OPENING + dateTime.toString() + COMMA + INCLUSIVE_CLOSING;
        return new SimpleExpression(this.propertyName, value, Operator.EQUALS);
    }

    public Criterion gte(Date date) {
        Assert.notNull((Object)date, (String)"date needs to be a valid Date object");
        DateTime dateTime = new DateTime((Object)date);
        String value = INCLUSIVE_OPENING + dateTime.toString() + COMMA + INCLUSIVE_CLOSING;
        return new SimpleExpression(this.propertyName, value, Operator.EQUALS);
    }

    public Criterion lt(Date date) {
        Assert.notNull((Object)date, (String)"date needs to be a valid Date object");
        DateTime dateTime = new DateTime((Object)date);
        String value = "[, " + dateTime.toString() + EXCLUSIVE_CLOSING;
        return new SimpleExpression(this.propertyName, value, Operator.EQUALS);
    }

    public Criterion lte(Date date) {
        Assert.notNull((Object)date, (String)"date needs to be a valid Date object");
        DateTime dateTime = new DateTime((Object)date);
        String value = "[, " + dateTime.toString() + INCLUSIVE_CLOSING;
        return new SimpleExpression(this.propertyName, value, Operator.EQUALS);
    }

    public Criterion equals(Date date) {
        Assert.notNull((Object)date, (String)"date needs to be a valid Date object");
        DateTime dateTime = new DateTime((Object)date);
        return new SimpleExpression(this.propertyName, dateTime.toString(), Operator.EQUALS);
    }

    public Criterion in(Date begin, Date end) {
        Assert.notNull((Object)begin, (String)"begin needs to be a valid Date object");
        Assert.notNull((Object)end, (String)"end needs to be a valid Date object");
        Assert.isTrue((boolean)begin.before(end), (String)"begin date needs to be earlier than end date");
        DateTime beginDateTime = new DateTime((Object)begin);
        DateTime endDateTime = new DateTime((Object)end);
        String value = INCLUSIVE_OPENING + beginDateTime.toString() + COMMA + endDateTime.toString() + EXCLUSIVE_CLOSING;
        return new SimpleExpression(this.propertyName, value, Operator.EQUALS);
    }

    public Criterion in(Date begin, Duration duration) {
        Assert.notNull((Object)begin, (String)"begin needs to be a valid Date object");
        Assert.notNull((Object)duration, (String)"duration needs to be a valid Duration object");
        DateTime beginDateTime = new DateTime((Object)begin);
        Date endDate = this.calculateDateFromDuration(begin, duration);
        Assert.isTrue((boolean)begin.before(endDate), (String)"begin date needs to be earlier than end date");
        DateTime endDateTime = new DateTime((Object)endDate);
        String value = INCLUSIVE_OPENING + beginDateTime.toString() + COMMA + endDateTime.toString() + EXCLUSIVE_CLOSING;
        return new SimpleExpression(this.propertyName, value, Operator.EQUALS);
    }

    private Date calculateDateFromDuration(Date begin, Duration duration) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(begin.getTime() + this.durationToMillis(duration));
        return cal.getTime();
    }

    private long durationToMillis(Duration duration) {
        switch (duration.getTimeUnit()) {
            case DAYS: {
                return TimeUnit.DAYS.toMillis(duration.getValue());
            }
            case HOURS: {
                return TimeUnit.HOURS.toMillis(duration.getValue());
            }
            case MINUTES: {
                return TimeUnit.MINUTES.toMillis(duration.getValue());
            }
            case SECONDS: {
                return TimeUnit.SECONDS.toMillis(duration.getValue());
            }
            case MILLISECONDS: {
                return duration.getValue();
            }
            case MICROSECONDS: {
                return TimeUnit.MICROSECONDS.toMillis(duration.getValue());
            }
            case NANOSECONDS: {
                return TimeUnit.NANOSECONDS.toMillis(duration.getValue());
            }
        }
        return 0L;
    }
}

