/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds.cache;

import com.okta.sdk.cache.Cache;
import com.okta.sdk.impl.ds.Filter;
import com.okta.sdk.impl.ds.ResourceDataRequest;
import com.okta.sdk.impl.ds.cache.CacheResolver;
import com.okta.sdk.impl.http.CanonicalUri;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Collections;
import com.okta.sdk.resource.CollectionResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;

abstract class AbstractCacheFilter
implements Filter {
    private final CacheResolver cacheResolver;
    private final boolean collectionCachingEnabled;

    protected AbstractCacheFilter(CacheResolver resolver, boolean collectionCachingEnabled) {
        Assert.notNull((Object)resolver, (String)"cacheResolver cannot be null.");
        this.cacheResolver = resolver;
        this.collectionCachingEnabled = collectionCachingEnabled;
    }

    protected boolean isCollectionCachingEnabled() {
        return this.collectionCachingEnabled;
    }

    protected Map<String, ?> getCachedValue(String href, Class<? extends Resource> clazz) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        Assert.notNull(clazz, (String)"Class argument cannot be null.");
        Cache<String, Map<String, ?>> cache = this.getCache(clazz);
        return (Map)cache.get((Object)href);
    }

    protected String getCacheKey(ResourceDataRequest request) {
        CanonicalUri uri = request.getUri();
        String href = uri.getAbsolutePath();
        QueryString query = uri.getQuery();
        Class<? extends Resource> clazz = request.getResourceClass();
        return this.getCacheKey(href, query, clazz);
    }

    protected String getCacheKey(String href, QueryString query, Class<? extends Resource> clazz) {
        String key = href;
        if (this.collectionCachingEnabled && CollectionResource.class.isAssignableFrom(clazz) && !Collections.isEmpty((Map)query)) {
            key = href + "?" + query.toString();
        }
        return key;
    }

    protected <T> Cache<String, Map<String, ?>> getCache(Class<T> clazz) {
        return this.cacheResolver.getCache(clazz);
    }
}

