/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.okta.sdk.impl.ds.DefaultDiscriminatorRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class DiscriminatorConfig {
    private static final Logger logger = LoggerFactory.getLogger(DiscriminatorConfig.class);
    private Map<String, ClassConfig> config;

    public Map<String, ClassConfig> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, ClassConfig> config) {
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static DiscriminatorConfig loadConfig() {
        Yaml yaml = new Yaml();
        String configFile = "/com/okta/sdk/resource/discrimination.yaml";
        URL configYaml = DefaultDiscriminatorRegistry.class.getResource(configFile);
        if (configYaml == null) {
            logger.warn("Could not find config file on the classpath: {}", (Object)configFile);
            return new DiscriminatorConfig();
        }
        try (InputStream is = configYaml.openStream();){
            DiscriminatorConfig discriminatorConfig = (DiscriminatorConfig)yaml.loadAs(is, DiscriminatorConfig.class);
            return discriminatorConfig;
        }
        catch (IOException e) {
            logger.warn("Failed to load config file: {}", (Object)configFile, (Object)e);
            return new DiscriminatorConfig();
        }
    }

    public static class ClassConfig {
        private String fieldName;
        private Map<String, String> values;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public Map<String, String> getValues() {
            return this.values;
        }

        public void setValues(Map<String, String> values) {
            this.values = values;
        }
    }
}

