/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.config;

import com.okta.sdk.impl.config.PropertiesSource;
import com.okta.sdk.impl.io.Resource;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YAMLPropertiesSource
implements PropertiesSource {
    private final Resource resource;

    public YAMLPropertiesSource(Resource resource) {
        Assert.notNull((Object)resource, (String)"resource argument cannot be null.");
        this.resource = resource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> getProperties() {
        try (InputStream in = this.resource.getInputStream();){
            if (in == null) return new LinkedHashMap<String, String>();
            Yaml yaml = new Yaml();
            Map config = (Map)yaml.loadAs(in, Map.class);
            Map<String, String> map = this.getFlattenedMap(config);
            return map;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read resource [" + this.resource + "]: " + e.getMessage(), e);
        }
    }

    protected final Map<String, String> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.buildFlattenedMap(result, source, null);
        return result;
    }

    private void buildFlattenedMap(Map<String, String> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (Strings.hasText((String)path)) {
                key = key.startsWith("[") ? path + key : path + "." + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key, String.valueOf(value));
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                result.put(key, Strings.collectionToCommaDelimitedString((Collection)collection));
                continue;
            }
            result.put(key, value != null ? String.valueOf(value) : "");
        }
    }
}

