/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.sdk.impl.ds.Enlistment;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractPropertyRetriever;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ReferenceFactory;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Strings;
import com.okta.sdk.resource.CollectionResource;
import com.okta.sdk.resource.Resource;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractResource
extends AbstractPropertyRetriever
implements Resource {
    protected final Map<String, Object> dirtyProperties;
    protected final Set<String> deletedPropertyNames;
    protected final ReferenceFactory referenceFactory = new ReferenceFactory();
    private final InternalDataStore dataStore;
    protected Map<String, Object> properties;
    private String href = null;
    protected volatile boolean dirty;
    private volatile boolean materialized;

    protected AbstractResource(InternalDataStore dataStore) {
        this(dataStore, null);
    }

    protected AbstractResource(InternalDataStore dataStore, Map<String, Object> properties) {
        this.dataStore = dataStore;
        this.dirtyProperties = new LinkedHashMap<String, Object>();
        this.deletedPropertyNames = new HashSet<String>();
        this.properties = properties instanceof Enlistment ? properties : new LinkedHashMap<String, Object>();
        this.setInternalProperties(properties);
    }

    public static boolean isMaterialized(Map<String, ?> props) {
        return props != null && props.size() > 1;
    }

    protected static Map<String, Property> createPropertyDescriptorMap(Property ... props) {
        LinkedHashMap<String, Property> m = new LinkedHashMap<String, Property>();
        for (Property prop : props) {
            m.put(prop.getName(), prop);
        }
        return m;
    }

    public abstract Map<String, Property> getPropertyDescriptors();

    public void setInternalProperties(Map<String, Object> properties) {
        this.writeLock.lock();
        try {
            this.dirtyProperties.clear();
            this.dirty = false;
            if (properties != null && !properties.isEmpty()) {
                if (this.properties instanceof Enlistment && this.properties != properties) {
                    this.properties.clear();
                    this.properties.putAll(properties);
                } else {
                    this.properties = properties;
                }
                this.setResourceHref(this.getSelfHref(properties));
                this.materialized = this.properties.size() > 0;
            } else {
                this.materialized = false;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String getSelfHref(Map<String, Object> properties) {
        Map<String, Object> links = this.getMapValue(properties, "_links");
        Map<String, Object> self = this.getMapValue(links, "self");
        if (!com.okta.sdk.lang.Collections.isEmpty(self)) {
            return (String)self.get("href");
        }
        return null;
    }

    private Map<String, Object> getMapValue(Map<String, Object> properties, String key) {
        if (!com.okta.sdk.lang.Collections.isEmpty(properties)) {
            return (Map)properties.get(key);
        }
        return null;
    }

    public String getResourceHref() {
        return this.href;
    }

    public void setResourceHref(String href) {
        this.href = href;
    }

    protected final InternalDataStore getDataStore() {
        return this.dataStore;
    }

    public final boolean isMaterialized() {
        return this.materialized;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    protected final boolean isNew() {
        String href = this.getResourceHref();
        return !Strings.hasText((String)href);
    }

    public void materialize() {
        if (this.materialized) {
            return;
        }
        AbstractResource resource = (AbstractResource)this.dataStore.getResource(this.getResourceHref(), this.getClass());
        this.writeLock.lock();
        try {
            if (this.properties != resource.properties) {
                if (!(this.properties instanceof Enlistment)) {
                    this.properties = resource.properties;
                } else {
                    this.properties.clear();
                    this.properties.putAll(resource.properties);
                }
            }
            this.properties.putAll(this.dirtyProperties);
            this.materialized = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<String> getPropertyNames() {
        this.readLock.lock();
        try {
            Set<String> keys = this.properties.keySet();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(keys);
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<String> getUpdatedPropertyNames() {
        this.readLock.lock();
        try {
            Set<String> keys = this.dirtyProperties.keySet();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(keys);
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected Set<String> getDeletedPropertyNames() {
        this.readLock.lock();
        try {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.deletedPropertyNames);
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Object getProperty(String name) {
        if (!this.isNew() && !this.isMaterialized()) {
            boolean present = false;
            this.readLock.lock();
            try {
                present = this.dirtyProperties.containsKey(name);
            }
            finally {
                this.readLock.unlock();
            }
            if (!present) {
                this.materialize();
            }
        }
        return this.readProperty(name);
    }

    public boolean hasProperty(String name) {
        this.readLock.lock();
        try {
            boolean bl = !this.deletedPropertyNames.contains(name) && (this.dirtyProperties.containsKey(name) || this.properties.containsKey(name));
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readProperty(String name) {
        this.readLock.lock();
        try {
            if (this.deletedPropertyNames.contains(name)) {
                Object var2_2 = null;
                return var2_2;
            }
            Object value = this.dirtyProperties.get(name);
            if (value == null) {
                value = this.properties.get(name);
            }
            Object object = value;
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    protected Object setProperty(String name, Object value, boolean dirty) {
        return this.setProperty(name, value, dirty, false);
    }

    protected void setProperty(Property property, Object value, boolean dirty, boolean isNullable) {
        this.setProperty(property.getName(), value, dirty, isNullable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object setProperty(String name, Object value, boolean dirty, boolean isNullable) {
        Object previous;
        this.writeLock.lock();
        try {
            previous = this.dirtyProperties.put(name, value);
            if (previous == null) {
                previous = this.properties.get(name);
            }
            this.dirty = dirty;
            if (isNullable && value == null) {
                this.deletedPropertyNames.add(name);
            } else if (this.deletedPropertyNames.contains(name)) {
                this.deletedPropertyNames.remove(name);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return previous;
    }

    protected <T extends Resource> T getResourceProperty(ResourceReference<T> property) {
        String key = property.getName();
        Class clazz = property.getType();
        Object value = this.getProperty(key);
        if (value == null) {
            if (property.isCreateOnAccess()) {
                Resource resource = this.dataStore.instantiate(clazz);
                this.setProperty(key, resource, false);
                return (T)resource;
            }
            return null;
        }
        if (clazz.isInstance(value)) {
            return (T)((Resource)value);
        }
        if (value instanceof Map) {
            Object resource = this.dataStore.instantiate(clazz, (Map)value);
            if (!CollectionResource.class.isAssignableFrom(clazz)) {
                this.setProperty(key, resource, false);
            }
            return resource;
        }
        String msg = "'" + key + "' property value type does not match the specified type.  Specified type: " + clazz.getName() + ".  Existing type: " + value.getClass().getName();
        msg = msg + (this.isPrintableProperty(key) ? ".  Value: " + value : ".");
        throw new IllegalArgumentException(msg);
    }

    protected List getListProperty(ListProperty property) {
        return this.getListProperty(property.getName());
    }

    @Override
    protected List getListProperty(String key) {
        Object list = this.getProperty(key);
        return (List)list;
    }

    @Override
    protected Set getSetProperty(String key) {
        Object set = this.getProperty(key);
        if (set instanceof List) {
            return new HashSet((List)set);
        }
        return (Set)set;
    }

    protected <T extends Resource> void setResourceProperty(ResourceReference<T> property, Resource value) {
        Assert.notNull(property, (String)"Property argument cannot be null.");
        String name = property.getName();
        Map<String, String> reference = this.referenceFactory.createReference(name, value);
        this.setProperty(name, reference);
    }

    protected <T extends Resource> void setMaterializableResourceProperty(ResourceReference<T> property, Resource value, boolean dirtyOnly) {
        Assert.notNull(property, (String)"Property argument cannot be null.");
        Assert.isNull((Object)value.getResourceHref(), (String)"Resource must not have an 'href' property ");
        if (((AbstractResource)value).isMaterialized()) {
            this.setResourceProperty(property, value);
        } else {
            String name = property.getName();
            Map<String, String> reference = this.referenceFactory.createUnmaterializedReference(name, value, dirtyOnly);
            this.setProperty(name, reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.readLock.lock();
        try {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                String key;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if (!this.isPrintableProperty(key = entry.getKey())) continue;
                sb.append(key).append(": ").append(String.valueOf(entry.getValue()));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    protected boolean isPrintableProperty(String name) {
        return true;
    }

    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.properties.isEmpty() ? 0 : this.properties.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractResource other = (AbstractResource)o;
        this.readLock.lock();
        try {
            other.readLock.lock();
            try {
                boolean bl = this.properties.equals(other.properties);
                other.readLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                other.readLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    protected Map<String, Object> getInternalProperties() {
        return this.properties;
    }

    public int size() {
        this.readLock.lock();
        try {
            LinkedHashSet<String> keySet = new LinkedHashSet<String>();
            keySet.addAll(this.properties.keySet());
            keySet.addAll(this.dirtyProperties.keySet());
            keySet.removeAll(this.deletedPropertyNames);
            int n = keySet.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    public boolean containsValue(Object value) {
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        Assert.isInstanceOf(String.class, (Object)key);
        return this.getProperty(key.toString());
    }

    public Object put(String key, Object value) {
        return this.setProperty(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Assert.isInstanceOf(String.class, (Object)key);
        this.writeLock.lock();
        try {
            Object object = this.dirtyProperties.remove(key);
            this.deletedPropertyNames.add(key.toString());
            this.dirty = true;
            Object object2 = object;
            return object2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends String, ?> m) {
        if (com.okta.sdk.lang.Collections.isEmpty(m)) {
            return;
        }
        Set<Map.Entry<String, ?>> entrySet = m.entrySet();
        this.writeLock.lock();
        try {
            for (Map.Entry<String, ?> entry : entrySet) {
                this.setProperty(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock.lock();
        try {
            HashSet<String> propertiesToFilter = new HashSet<String>();
            propertiesToFilter.addAll(this.getPropertyDescriptors().keySet());
            for (String propertyName : this.keySet()) {
                if (propertiesToFilter.contains(propertyName)) continue;
                this.dirtyProperties.remove(propertyName);
                this.deletedPropertyNames.add(propertyName);
                this.dirty = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<String> keySet() {
        if (!this.isMaterialized()) {
            this.writeLock.lock();
            try {
                this.materialize();
            }
            finally {
                this.writeLock.unlock();
            }
        }
        this.readLock.lock();
        try {
            LinkedHashSet<String> keySet = new LinkedHashSet<String>();
            keySet.addAll(this.properties.keySet());
            keySet.addAll(this.dirtyProperties.keySet());
            keySet.removeAll(this.deletedPropertyNames);
            Set<String> set = Collections.unmodifiableSet(keySet);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection<Object> values() {
        Set<String> keySet = this.keySet();
        ArrayList<Object> values = new ArrayList<Object>(keySet.size());
        for (String key : keySet) {
            values.add(this.get(key));
        }
        return Collections.unmodifiableCollection(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<String, Object>> entrySet() {
        Set<String> keySet = this.keySet();
        this.readLock.lock();
        try {
            LinkedHashSet<AbstractMap.SimpleEntry<String, Object>> entrySet = new LinkedHashSet<AbstractMap.SimpleEntry<String, Object>>(keySet.size());
            for (String key : keySet) {
                entrySet.add(new AbstractMap.SimpleEntry<String, Object>(key, this.get(key)));
            }
            Set set = Collections.unmodifiableSet(entrySet);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

