/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.error;

import com.okta.sdk.error.Error;
import com.okta.sdk.error.authc.OAuthAuthenticationException;
import com.okta.sdk.impl.error.DefaultErrorBuilder;
import com.okta.sdk.lang.Classes;
import com.okta.sdk.lang.Strings;
import com.okta.sdk.resource.ResourceException;
import java.lang.reflect.Constructor;

public class ApiAuthenticationExceptionFactory {
    public static final int AUTH_EXCEPTION_STATUS = 401;
    public static final String AUTH_EXCEPTION_CODE = "401";
    private static final String DEFAULT_CLIENT_MESSAGE = "Authentication Required";

    public static ResourceException newApiAuthenticationException(Class<? extends ResourceException> clazz) {
        Error error = DefaultErrorBuilder.status(401).code(AUTH_EXCEPTION_CODE).message(DEFAULT_CLIENT_MESSAGE).build();
        Constructor constructor = Classes.getConstructor(clazz, (Class[])new Class[]{Error.class});
        return (ResourceException)Classes.instantiate((Constructor)constructor, (Object[])new Object[]{error});
    }

    public static ResourceException newApiAuthenticationException(Class<? extends ResourceException> clazz, String message) {
        if (Strings.isEmpty((Object)message)) {
            message = DEFAULT_CLIENT_MESSAGE;
        }
        Error error = DefaultErrorBuilder.status(401).code(AUTH_EXCEPTION_CODE).message(ApiAuthenticationExceptionFactory.getOrDefaultErrorMessage(message)).build();
        Constructor<? extends ResourceException> constructor = ApiAuthenticationExceptionFactory.getConstructorFromClass(clazz);
        return (ResourceException)Classes.instantiate(constructor, (Object[])new Object[]{error});
    }

    public static ResourceException newOAuthException(Class<? extends OAuthAuthenticationException> clazz, String message) {
        Error error = DefaultErrorBuilder.status(401).code(AUTH_EXCEPTION_CODE).message(ApiAuthenticationExceptionFactory.getOrDefaultErrorMessage(message)).build();
        Constructor<? extends ResourceException> constructor = ApiAuthenticationExceptionFactory.getConstructorFromClass(clazz);
        return (ResourceException)Classes.instantiate(constructor, (Object[])new Object[]{error, message});
    }

    private static Constructor<? extends ResourceException> getConstructorFromClass(Class<? extends ResourceException> clazz) {
        if (OAuthAuthenticationException.class.isAssignableFrom(clazz)) {
            return Classes.getConstructor(clazz, (Class[])new Class[]{Error.class, String.class});
        }
        return Classes.getConstructor(clazz, (Class[])new Class[]{Error.class});
    }

    private static String getOrDefaultErrorMessage(String nullableErrorMessage) {
        if (Strings.isEmpty((Object)nullableErrorMessage)) {
            nullableErrorMessage = DEFAULT_CLIENT_MESSAGE;
        }
        return nullableErrorMessage;
    }
}

