/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.okta.sdk.impl.ds.DefaultResourceDataResult;
import com.okta.sdk.impl.ds.Enlistment;
import com.okta.sdk.impl.ds.Filter;
import com.okta.sdk.impl.ds.FilterChain;
import com.okta.sdk.impl.ds.ResourceAction;
import com.okta.sdk.impl.ds.ResourceDataRequest;
import com.okta.sdk.impl.ds.ResourceDataResult;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.util.SoftHashMap;
import com.okta.sdk.lang.Assert;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class EnlistmentFilter
implements Filter {
    private final Map<String, Enlistment> hrefMapStore = new SoftHashMap<String, Enlistment>();

    @Override
    public ResourceDataResult filter(ResourceDataRequest request, FilterChain chain) {
        ResourceDataResult result = chain.filter(request);
        Enlistment data = result.getData();
        if (request.getAction() == ResourceAction.DELETE) {
            this.hrefMapStore.remove(result.getUri().getAbsolutePath());
        } else if (AbstractInstanceResource.isInstanceResource(data)) {
            data = this.toEnlistment(data);
            result = new DefaultResourceDataResult(result.getAction(), result.getUri(), result.getResourceClass(), data);
        }
        return result;
    }

    private Enlistment toEnlistment(Map<String, ?> data) {
        Enlistment enlistment;
        Assert.notEmpty(data, (String)"data cannot be null or empty.");
        String href = (String)data.get("href");
        Assert.hasText((String)href, (String)"href cannot be null or empty.");
        LinkedHashMap<String, Object> modified = new LinkedHashMap<String, Object>(data.size());
        Iterator<Map.Entry<String, ?>> iterator = data.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> o;
            Map.Entry<String, ?> entry = o = iterator.next();
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map && AbstractInstanceResource.isInstanceResource((Map)value)) {
                value = this.toEnlistment((Map)value);
            }
            modified.put(key, value);
        }
        if (this.hrefMapStore.containsKey(href)) {
            enlistment = this.hrefMapStore.get(href);
            enlistment.setProperties(modified);
        } else {
            enlistment = new Enlistment(modified);
            this.hrefMapStore.put(href, enlistment);
        }
        return enlistment;
    }
}

