/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.okta.sdk.impl.ds.MapMarshaller;
import com.okta.sdk.impl.ds.MarshalingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JacksonMapMarshaller
implements MapMarshaller {
    private ObjectMapper objectMapper = new ObjectMapper();

    public JacksonMapMarshaller() {
        this.objectMapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isPrettyPrint() {
        return this.objectMapper.getSerializationConfig().isEnabled(SerializationFeature.INDENT_OUTPUT);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, prettyPrint);
    }

    @Override
    public String marshal(Map map) {
        try {
            return this.objectMapper.writeValueAsString((Object)map);
        }
        catch (IOException e) {
            throw new MarshalingException("Unable to convert Map to JSON String.", e);
        }
    }

    @Override
    public Map unmarshal(String marshalled) {
        try {
            TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
            return (Map)this.objectMapper.readValue(marshalled, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new MarshalingException("Unable to convert JSON String to Map.", e);
        }
    }

    @Override
    public Map<String, Object> unmarshall(InputStream marshalled, Map<String, String> linkMap) {
        try {
            Object resolvedObj = this.objectMapper.readValue(marshalled, Object.class);
            if (resolvedObj instanceof Map) {
                return (Map)resolvedObj;
            }
            if (resolvedObj instanceof List) {
                List list = (List)resolvedObj;
                LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
                ret.put("items", list);
                ret.put("nextPage", linkMap.get("next"));
                ret.put("href", "local");
                return ret;
            }
            throw new MarshalingException("Unable to convert InputStream String to Map. Resolved Object is neither a Map or a List: " + resolvedObj.getClass());
        }
        catch (IOException e) {
            throw new MarshalingException("Unable to convert InputStream String to Map.", e);
        }
    }
}

