/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.client;

import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.Proxy;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.client.AbstractClient;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.okta.sdk.impl.util.BaseUrlResolver;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.group.rule.GroupRuleList;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserList;

public class DefaultClient
extends AbstractClient {
    public DefaultClient(ClientCredentialsResolver clientCredentialsResolver, BaseUrlResolver baseUrlResolver, Proxy proxy, CacheManager cacheManager, AuthenticationScheme authenticationScheme, RequestAuthenticatorFactory requestAuthenticatorFactory, int connectionTimeout) {
        super(clientCredentialsResolver, baseUrlResolver, proxy, cacheManager, authenticationScheme, requestAuthenticatorFactory, connectionTimeout);
    }

    public Group createGroup(Group body) {
        String href = "/api/v1/groups";
        return this.getDataStore().create(href, body, Group.class);
    }

    public GroupRule createRule(GroupRule body) {
        String href = "/api/v1/groups/rules";
        return this.getDataStore().create(href, body, GroupRule.class);
    }

    public User createUser(User body, Boolean activate, Boolean provider) {
        QueryString queryArgs = new QueryString();
        queryArgs.put("activate", activate);
        queryArgs.putIfAbsent("activate", "true");
        queryArgs.put("provider", provider);
        queryArgs.putIfAbsent("provider", "false");
        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        return this.getDataStore().create(href, body, User.class);
    }

    public User createUser(User body) {
        String href = "/api/v1/users";
        return this.getDataStore().create(href, body, User.class);
    }

    public Group getGroup(String groupId, String expand) {
        QueryString queryArgs = new QueryString();
        queryArgs.put("expand", expand);
        String href = QueryString.buildHref("/api/v1/groups/" + groupId + "", queryArgs);
        return (Group)this.getDataStore().getResource(href, Group.class);
    }

    public Group getGroup(String groupId) {
        String href = "/api/v1/groups/" + groupId + "";
        return (Group)this.getDataStore().getResource(href, Group.class);
    }

    public GroupRule getRule(String ruleId) {
        String href = "/api/v1/groups/rules/" + ruleId + "";
        return (GroupRule)this.getDataStore().getResource(href, GroupRule.class);
    }

    public User getUser(String userId) {
        String href = "/api/v1/users/" + userId + "";
        return (User)this.getDataStore().getResource(href, User.class);
    }

    public GroupList listGroups(String q, String filter, String expand) {
        QueryString queryArgs = new QueryString();
        queryArgs.put("q", q);
        queryArgs.put("filter", filter);
        queryArgs.put("expand", expand);
        String href = QueryString.buildHref("/api/v1/groups", queryArgs);
        return (GroupList)this.getDataStore().getResource(href, GroupList.class);
    }

    public GroupList listGroups() {
        String href = "/api/v1/groups";
        return (GroupList)this.getDataStore().getResource(href, GroupList.class);
    }

    public GroupRuleList listRules() {
        String href = "/api/v1/groups/rules";
        return (GroupRuleList)this.getDataStore().getResource(href, GroupRuleList.class);
    }

    public UserList listUsers(String q, String filter, String format, String search, String expand) {
        QueryString queryArgs = new QueryString();
        queryArgs.put("q", q);
        queryArgs.put("filter", filter);
        queryArgs.put("format", format);
        queryArgs.put("search", search);
        queryArgs.put("expand", expand);
        String href = QueryString.buildHref("/api/v1/users", queryArgs);
        return (UserList)this.getDataStore().getResource(href, UserList.class);
    }

    public UserList listUsers() {
        String href = "/api/v1/users";
        return (UserList)this.getDataStore().getResource(href, UserList.class);
    }
}

