/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.group;

import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupProfile;
import com.okta.sdk.resource.user.UserList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DefaultGroup
extends AbstractInstanceResource<Group>
implements Group {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastMembershipUpdatedProperty = new DateProperty("lastMembershipUpdated");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final ListProperty objectClassProperty = new ListProperty("objectClass");
    private static final ResourceReference<GroupProfile> profileProperty = new ResourceReference<GroupProfile>("profile", GroupProfile.class, true);
    private static final StringProperty typeProperty = new StringProperty("type");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultGroup.createPropertyDescriptorMap(embeddedProperty, linksProperty, createdProperty, idProperty, lastMembershipUpdatedProperty, lastUpdatedProperty, objectClassProperty, profileProperty, typeProperty);

    public DefaultGroup(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultGroup(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastMembershipUpdated() {
        return this.getDateProperty(lastMembershipUpdatedProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public List<String> getObjectClass() {
        return this.getListProperty(objectClassProperty);
    }

    public GroupProfile getProfile() {
        return this.getResourceProperty(profileProperty);
    }

    public Group setProfile(GroupProfile profile) {
        this.setProperty(profileProperty, (Object)profile);
        return this;
    }

    public String getType() {
        return this.getString(typeProperty);
    }

    public UserList listUsers() {
        String groupId = this.getId();
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        String href = "/api/v1/groups/" + groupId + "/users";
        return (UserList)this.getDataStore().getResource(href, UserList.class);
    }

    public Group update() {
        String groupId = this.getId();
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        String href = "/api/v1/groups/" + groupId + "";
        this.getDataStore().save(href, this);
        return this;
    }

    @Override
    public void delete() {
        String groupId = this.getId();
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        String href = "/api/v1/groups/" + groupId + "";
        this.getDataStore().delete(href);
    }

    public void removeUser(String userId) {
        String groupId = this.getId();
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/groups/" + groupId + "/users/" + userId + "";
        this.getDataStore().delete(href);
    }
}

