/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import com.okta.sdk.client.Client;
import com.okta.sdk.client.ClientBuilder;
import com.okta.sdk.client.Clients;
import com.okta.sdk.resource.ResourceException;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupBuilder;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserBuilder;
import com.okta.sdk.resource.user.UserList;
import com.okta.sdk.resource.user.UserStatus;
import java.util.UUID;

public class Quickstart {
    public static void main(String[] args) {
        String email = "joe.coder+" + UUID.randomUUID().toString() + "@example.com";
        String groupName = "java-sdk-quickstart-" + UUID.randomUUID().toString();
        char[] password = new char[]{'P', 'a', 's', 's', 'w', 'o', 'r', 'd', '1'};
        Group group = null;
        User user = null;
        try {
            ClientBuilder builder = Clients.builder();
            Client client = builder.build();
            group = GroupBuilder.instance().setName(groupName).setDescription("Quickstart created Group").buildAndCreate(client);
            Quickstart.println("Group: '" + group.getId() + "' was last updated on: " + group.getLastUpdated());
            user = UserBuilder.instance().setEmail(email).setFirstName("Joe").setLastName("Coder").setPassword(password).setSecurityQuestion("Favorite security question?").setSecurityQuestionAnswer("None of them!").putProfileProperty("division", (Object)"Seven").setActive(Boolean.valueOf(true)).buildAndCreate(client);
            user.addToGroup(group.getId());
            String userId = user.getId();
            Quickstart.println("User created with ID: " + userId);
            Quickstart.println("User lookup by ID: " + client.getUser(userId).getProfile().getLogin());
            Quickstart.println("User lookup by Email: " + client.getUser(email).getProfile().getLogin());
            UserList users = client.listUsers();
            Quickstart.println("First user in collection: " + ((User)users.iterator().next()).getProfile().getEmail());
        }
        catch (ResourceException e) {
            Quickstart.println(e.getMessage());
            e.getCauses().forEach(cause -> Quickstart.println("\t" + cause.getSummary()));
            throw e;
        }
        finally {
            if (user != null) {
                if (user.getStatus() != UserStatus.DEPROVISIONED) {
                    user.deactivate();
                }
                user.delete();
            }
            if (group != null) {
                group.delete();
            }
        }
    }

    private static void println(String message) {
        System.out.println(message);
        System.out.flush();
    }
}

