/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import com.okta.sdk.client.ClientBuilder;
import com.okta.sdk.client.Clients;
import com.okta.sdk.resource.api.GroupApi;
import com.okta.sdk.resource.api.UserApi;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.group.GroupBuilder;
import com.okta.sdk.resource.model.Group;
import com.okta.sdk.resource.model.User;
import com.okta.sdk.resource.model.UserStatus;
import com.okta.sdk.resource.user.UserBuilder;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class Quickstart {
    public static void main(String[] args) throws ApiException {
        String email = "joe.coder+" + UUID.randomUUID() + "@example.com";
        String groupName = "java-sdk-quickstart-" + UUID.randomUUID();
        char[] password = new char[]{'$', 'D', 'o', 'l', 'l', 'a', 'r', 'd', 'i', 'm', 'e', '1', '2', '3', '*'};
        Group group = null;
        User user = null;
        UserApi userApi = null;
        GroupApi groupApi = null;
        try {
            ClientBuilder builder = Clients.builder();
            ApiClient client = builder.build();
            userApi = new UserApi(client);
            groupApi = new GroupApi(client);
            group = GroupBuilder.instance().setName(groupName).setDescription("Quickstart created Group").buildAndCreate(groupApi);
            Quickstart.println("Group: '" + group.getId() + "' was last updated on: " + group.getLastUpdated());
            user = UserBuilder.instance().setEmail(email).setFirstName("Joe").setLastName("Coder").setPassword(password).setSecurityQuestion("Favorite security question?").setSecurityQuestionAnswer("None of them!").setActive(Boolean.valueOf(true)).addGroup(group.getId()).buildAndCreate(userApi);
            String userId = user.getId();
            Quickstart.println("User created with ID: " + userId);
            Quickstart.println("User lookup by ID: " + Objects.requireNonNull(userApi.getUser(userId, null, "false").getProfile()).getLogin());
            Quickstart.println("User lookup by Email: " + Objects.requireNonNull(userApi.getUser(email, null, "false").getProfile()).getLogin());
            List users = userApi.listUsers(null, null, null, null, "status eq \"ACTIVE\"", null, null, null);
            Quickstart.println("First user in collection: " + Objects.requireNonNull(Objects.requireNonNull(users.stream().findFirst().orElse(null)).getProfile()).getEmail());
        }
        catch (Exception e) {
            Quickstart.println(e.getMessage());
            throw e;
        }
        finally {
            if (user != null) {
                if (!Objects.equals(user.getStatus(), UserStatus.DEPROVISIONED)) {
                    userApi.deleteUser(user.getId(), Boolean.valueOf(false), null);
                }
                userApi.deleteUser(user.getId(), Boolean.valueOf(false), null);
            }
            if (group != null) {
                groupApi.deleteGroup(group.getId());
            }
        }
    }

    private static void println(String message) {
        System.out.println(message);
        System.out.flush();
    }
}

