/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import com.fasterxml.jackson.core.type.TypeReference;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.authc.credentials.TokenClientCredentials;
import com.okta.sdk.cache.Caches;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.AuthorizationMode;
import com.okta.sdk.client.Clients;
import com.okta.sdk.resource.api.ApplicationApi;
import com.okta.sdk.resource.api.GroupApi;
import com.okta.sdk.resource.api.PolicyApi;
import com.okta.sdk.resource.api.SystemLogApi;
import com.okta.sdk.resource.api.UserApi;
import com.okta.sdk.resource.api.UserFactorApi;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.common.PagedList;
import com.okta.sdk.resource.group.GroupBuilder;
import com.okta.sdk.resource.model.ActivateFactorRequest;
import com.okta.sdk.resource.model.Application;
import com.okta.sdk.resource.model.ApplicationSignOnMode;
import com.okta.sdk.resource.model.BookmarkApplication;
import com.okta.sdk.resource.model.BookmarkApplicationSettings;
import com.okta.sdk.resource.model.BookmarkApplicationSettingsApplication;
import com.okta.sdk.resource.model.BrowserPluginApplication;
import com.okta.sdk.resource.model.CallUserFactor;
import com.okta.sdk.resource.model.FactorProvider;
import com.okta.sdk.resource.model.FactorType;
import com.okta.sdk.resource.model.Group;
import com.okta.sdk.resource.model.HttpMethod;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.MultifactorEnrollmentPolicy;
import com.okta.sdk.resource.model.PolicyType;
import com.okta.sdk.resource.model.SmsUserFactor;
import com.okta.sdk.resource.model.SmsUserFactorProfile;
import com.okta.sdk.resource.model.SwaApplicationSettings;
import com.okta.sdk.resource.model.SwaApplicationSettingsApplication;
import com.okta.sdk.resource.model.UpdateUserRequest;
import com.okta.sdk.resource.model.User;
import com.okta.sdk.resource.model.UserFactor;
import com.okta.sdk.resource.model.UserProfile;
import com.okta.sdk.resource.model.VerifyFactorRequest;
import com.okta.sdk.resource.model.VerifyUserFactorResponse;
import com.okta.sdk.resource.user.UserBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadmeSnippets {
    private static final Logger log = LoggerFactory.getLogger(ReadmeSnippets.class);
    private final ApiClient client = Clients.builder().build();
    private final User user = null;

    private void createClient() {
        ApiClient client = Clients.builder().setOrgUrl("https://{yourOktaDomain}").setClientCredentials((ClientCredentials)new TokenClientCredentials("{apiToken}")).build();
    }

    private void createOAuth2Client() {
        ApiClient client = Clients.builder().setOrgUrl("https://{yourOktaDomain}").setAuthorizationMode(AuthorizationMode.PRIVATE_KEY).setClientId("{clientId}").setKid("{kid}").setScopes(new HashSet<String>(Arrays.asList("okta.users.manage", "okta.apps.manage", "okta.groups.manage"))).setPrivateKey("/path/to/yourPrivateKey.pem").build();
    }

    private void getUser() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        User user = userApi.getUser("userId");
    }

    private void listAllUsers() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        List users = userApi.listUsers(null, null, Integer.valueOf(5), null, null, null, null);
        users.stream().forEach(user -> {});
    }

    private void userSearch() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        List users = userApi.listUsers(null, null, Integer.valueOf(5), null, "profile.email eq \"jcoder@example.com\"", null, null);
        userApi.listUsers(null, null, null, "status eq \"ACTIVE\"", null, null, null);
    }

    private void createUser() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        User user = UserBuilder.instance().setEmail("joe.coder@example.com").setFirstName("Joe").setLastName("Code").buildAndCreate(userApi);
    }

    private void createUserWithGroups() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        User user = UserBuilder.instance().setEmail("joe.coder@example.com").setFirstName("Joe").setLastName("Code").setGroups(Arrays.asList("groupId-1", "groupId-2")).buildAndCreate(userApi);
    }

    private void updateUser() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        UpdateUserRequest updateUserRequest = new UpdateUserRequest();
        UserProfile userProfile = new UserProfile();
        userProfile.setNickName("Batman");
        updateUserRequest.setProfile(userProfile);
        userApi.updateUser(this.user.getId(), updateUserRequest, Boolean.valueOf(true));
    }

    private void updateUserWithCustomAttributes() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        UpdateUserRequest updateUserRequest = new UpdateUserRequest();
        UserProfile userProfile = new UserProfile();
        userProfile.getAdditionalProperties().put("foo", "bar");
        updateUserRequest.setProfile(userProfile);
        userApi.updateUser(this.user.getId(), updateUserRequest, Boolean.valueOf(true));
    }

    private void deleteUser() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        userApi.deactivateUser(this.user.getId(), Boolean.valueOf(false));
        userApi.deleteUser(this.user.getId(), Boolean.valueOf(false));
    }

    private void listGroups() throws ApiException {
        GroupApi groupApi = new GroupApi(this.client);
        List groups = groupApi.listGroups(null, null, null, Integer.valueOf(10), null, null, null, null);
    }

    private void createGroup() throws ApiException {
        GroupApi groupApi = new GroupApi(this.client);
        Group group = GroupBuilder.instance().setName("a-group-name").setDescription("Example Group").buildAndCreate(groupApi);
    }

    private void assignUserToGroup() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        User user = UserBuilder.instance().setEmail("joe.coder@example.com").setFirstName("Joe").setLastName("Code").buildAndCreate(userApi);
        GroupApi groupApi = new GroupApi(this.client);
        Group group = GroupBuilder.instance().setName("a-group-name").setDescription("Example Group").buildAndCreate(groupApi);
        groupApi.assignUserToGroup(group.getId(), user.getId());
    }

    private void listUserFactors() throws ApiException {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        List userFactors = userFactorApi.listFactors("userId");
    }

    private void getUserFactor() throws ApiException {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        UserFactor userFactor = userFactorApi.getFactor("userId", "factorId");
    }

    private void enrollUserInFactor() throws ApiException {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        SmsUserFactorProfile smsUserFactorProfile = new SmsUserFactorProfile();
        smsUserFactorProfile.setPhoneNumber("555 867 5309");
        SmsUserFactor smsUserFactor = new SmsUserFactor();
        smsUserFactor.setProvider(FactorProvider.OKTA);
        smsUserFactor.setFactorType(FactorType.SMS);
        smsUserFactor.setProfile(smsUserFactorProfile);
        userFactorApi.enrollFactor("userId", (UserFactor)smsUserFactor, Boolean.valueOf(true), "templateId", Integer.valueOf(30), Boolean.valueOf(true));
    }

    private void activateFactor() throws ApiException {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        CallUserFactor userFactor = (CallUserFactor)userFactorApi.getFactor("userId", "factorId");
        ActivateFactorRequest activateFactorRequest = new ActivateFactorRequest();
        activateFactorRequest.setPassCode("123456");
        userFactorApi.activateFactor("userId", "factorId", activateFactorRequest);
    }

    private void verifyFactor() throws ApiException {
        UserFactorApi userFactorApi = new UserFactorApi(this.client);
        UserFactor userFactor = userFactorApi.getFactor("userId", "factorId");
        VerifyFactorRequest verifyFactorRequest = new VerifyFactorRequest();
        verifyFactorRequest.setPassCode("123456");
        VerifyUserFactorResponse verifyUserFactorResponse = userFactorApi.verifyFactor("userId", "factorId", "templateId", Integer.valueOf(10), "xForwardedFor", "userAgent", "acceptLanguage", verifyFactorRequest);
    }

    private void listApplications() throws ApiException {
        ApplicationApi applicationApi = new ApplicationApi(this.client);
        List applications = applicationApi.listApplications(null, null, null, null, null, Boolean.valueOf(true));
    }

    private void getApplication() throws ApiException {
        ApplicationApi applicationApi = new ApplicationApi(this.client);
        BookmarkApplication bookmarkApp = (BookmarkApplication)applicationApi.getApplication("bookmark-app-id", null);
    }

    private void createSwaApplication() throws ApiException {
        ApplicationApi applicationApi = new ApplicationApi(this.client);
        SwaApplicationSettingsApplication swaApplicationSettingsApplication = new SwaApplicationSettingsApplication();
        swaApplicationSettingsApplication.buttonField("btn-login").passwordField("txtbox-password").usernameField("txtbox-username").url("https://example.com/login.html");
        SwaApplicationSettings swaApplicationSettings = new SwaApplicationSettings();
        swaApplicationSettings.app(swaApplicationSettingsApplication);
        BrowserPluginApplication browserPluginApplication = new BrowserPluginApplication();
        browserPluginApplication.name("template_swa");
        browserPluginApplication.label("Sample Plugin App");
        browserPluginApplication.settings(swaApplicationSettings);
        BrowserPluginApplication createdApp = (BrowserPluginApplication)applicationApi.createApplication((Application)browserPluginApplication, Boolean.valueOf(true), null);
    }

    private void listPolicies() throws ApiException {
        PolicyApi policyApi = new PolicyApi(this.client);
        List policies = policyApi.listPolicies(PolicyType.PASSWORD.name(), LifecycleStatus.ACTIVE.name(), null);
    }

    private void getPolicy() throws ApiException {
        PolicyApi policyApi = new PolicyApi(this.client);
        MultifactorEnrollmentPolicy mfaPolicy = (MultifactorEnrollmentPolicy)policyApi.getPolicy("mfa-policy-id", null);
    }

    private void listSysLogs() throws ApiException {
        SystemLogApi systemLogApi = new SystemLogApi(this.client);
        List logEvents = systemLogApi.listLogEvents(null, null, null, "interestingURI.com", Integer.valueOf(100), "ASCENDING", null);
    }

    private void callAnotherEndpoint() throws ApiException {
        ApiClient apiClient = ReadmeSnippets.buildApiClient("orgBaseUrl", "apiKey");
        BookmarkApplication bookmarkApplication = new BookmarkApplication();
        bookmarkApplication.setName("bookmark");
        bookmarkApplication.setLabel("Sample Bookmark App");
        bookmarkApplication.setSignOnMode(ApplicationSignOnMode.BOOKMARK);
        BookmarkApplicationSettings bookmarkApplicationSettings = new BookmarkApplicationSettings();
        BookmarkApplicationSettingsApplication bookmarkApplicationSettingsApplication = new BookmarkApplicationSettingsApplication();
        bookmarkApplicationSettingsApplication.setUrl("https://example.com/bookmark.htm");
        bookmarkApplicationSettingsApplication.setRequestIntegration(Boolean.valueOf(false));
        bookmarkApplicationSettings.setApp(bookmarkApplicationSettingsApplication);
        bookmarkApplication.setSettings(bookmarkApplicationSettings);
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap localVarHeaderParams = new HashMap();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        BookmarkApplication createdApp = (BookmarkApplication)apiClient.invokeAPI("/api/v1/apps", HttpMethod.POST.name(), localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), (Object)bookmarkApplication, localVarHeaderParams, localVarCookieParams, localVarFormParams, "application/json", "application/json", new String[]{"apiToken", "oauth2"}, (TypeReference)new TypeReference<BookmarkApplication>(){});
    }

    private void paginate() throws ApiException {
        UserApi userApi = new UserApi(this.client);
        int pageSize = 10;
        PagedList pagedUserList = new PagedList();
        do {
            pagedUserList = (PagedList)userApi.listUsers(null, pagedUserList.getAfter(), Integer.valueOf(pageSize), null, null, null, null);
            pagedUserList.forEach(usr -> log.info("User: {}", (Object)usr.getProfile().getEmail()));
        } while (pagedUserList.hasMoreItems());
    }

    private void complexCaching() {
        Caches.newCacheManager().withDefaultTimeToLive(300L, TimeUnit.SECONDS).withDefaultTimeToIdle(300L, TimeUnit.SECONDS).withCache(Caches.forResource(User.class).withTimeToLive(1L, TimeUnit.HOURS).withTimeToIdle(30L, TimeUnit.MINUTES)).withCache(Caches.forResource(Group.class).withTimeToLive(1L, TimeUnit.HOURS)).build();
    }

    private void disableCaching() {
        ApiClient client = Clients.builder().setCacheManager(Caches.newDisabledCacheManager()).build();
    }

    private static ApiClient buildApiClient(String orgBaseUrl, String apiKey) {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(orgBaseUrl);
        apiClient.setApiKey(apiKey);
        apiClient.setApiKeyPrefix(AuthenticationScheme.SSWS.name());
        return apiClient;
    }
}

