/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import com.okta.sdk.client.ClientBuilder;
import com.okta.sdk.client.Clients;
import com.okta.sdk.resource.group.GroupBuilder;
import com.okta.sdk.resource.user.UserBuilder;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.openapitools.client.ApiClient;
import org.openapitools.client.api.GroupApi;
import org.openapitools.client.api.UserApi;
import org.openapitools.client.model.Group;
import org.openapitools.client.model.User;
import org.openapitools.client.model.UserStatus;

public class Quickstart {
    public static void main(String[] args) {
        String email = "joe.coder+" + UUID.randomUUID() + "@example.com";
        String groupName = "java-sdk-quickstart-" + UUID.randomUUID().toString();
        char[] password = new char[]{'P', 'a', 's', 's', 'w', 'o', 'r', 'd', '1'};
        Group group = null;
        User user = null;
        UserApi userApi = null;
        GroupApi groupApi = null;
        try {
            ClientBuilder builder = Clients.builder();
            ApiClient client = builder.build();
            userApi = new UserApi(client);
            groupApi = new GroupApi(client);
            group = GroupBuilder.instance().setName(groupName).setDescription("Quickstart created Group").buildAndCreate(groupApi);
            Quickstart.println("Group: '" + group.getId() + "' was last updated on: " + group.getLastUpdated());
            user = UserBuilder.instance().setEmail(email).setFirstName("Joe").setLastName("Coder").setPassword(password).setSecurityQuestion("Favorite security question?").setSecurityQuestionAnswer("None of them!").setActive(Boolean.valueOf(true)).addGroup(group.getId()).buildAndCreate(userApi);
            String userId = user.getId();
            Quickstart.println("User created with ID: " + userId);
            Quickstart.println("User lookup by ID: " + userApi.getUser(userId).getProfile().getLogin());
            Quickstart.println("User lookup by Email: " + userApi.getUser(email).getProfile().getLogin());
            List users = userApi.listUsers(null, null, null, "status eq \"ACTIVE\"", null, null, null);
            Quickstart.println("First user in collection: " + ((User)users.stream().findFirst().get()).getProfile().getEmail());
        }
        catch (Exception e) {
            Quickstart.println(e.getMessage());
            throw e;
        }
        finally {
            if (user != null) {
                if (!Objects.equals(user.getStatus(), UserStatus.DEPROVISIONED)) {
                    userApi.deactivateUser(user.getId(), Boolean.valueOf(false));
                }
                userApi.deleteUser(user.getId(), Boolean.valueOf(false));
            }
            if (group != null) {
                groupApi.deleteGroup(group.getId());
            }
        }
    }

    private static void println(String message) {
        System.out.println(message);
        System.out.flush();
    }
}

