/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import com.okta.sdk.client.Client;
import com.okta.sdk.client.ClientBuilder;
import com.okta.sdk.client.Clients;
import com.okta.sdk.resource.ResourceException;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupBuilder;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserBuilder;
import com.okta.sdk.resource.user.UserList;
import java.util.UUID;

public class Quickstart {
    public static void main(String[] args) {
        try {
            ClientBuilder builder = Clients.builder();
            Client client = builder.build();
            Group group = GroupBuilder.INSTANCE.setName("my-user-group-" + UUID.randomUUID().toString()).setDescription("Quickstart created Group").buildAndCreate(client);
            Quickstart.println("Group: '" + group.getId() + "' was last updated on: " + group.getLastUpdated());
            String email = "joe.coder+" + UUID.randomUUID().toString() + "@example.com";
            User user = UserBuilder.INSTANCE.setEmail(email).setFirstName("Joe").setLastName("Coder").setPassword("Password1").setSecurityQuestion("Favorite security question?").setSecurityQuestionAnswer("None of them!").putProfileProperty("division", (Object)"Seven").buildAndCreate(client, true);
            user.addToGroup(group.getId());
            String userId = user.getId();
            Quickstart.println("User created with ID: " + userId);
            Quickstart.println("User lookup by ID: " + client.getUser(userId).getProfile().getLogin());
            Quickstart.println("User lookup by Email: " + client.getUser(email).getProfile().getLogin());
            UserList users = client.listUsers();
            Quickstart.println("First user in collection: " + ((User)users.iterator().next()).getProfile().getEmail());
        }
        catch (ResourceException e) {
            Quickstart.println(e.getMessage());
            e.getCauses().forEach(cause -> Quickstart.println("\t" + cause.getSummary()));
            throw e;
        }
    }

    private static void println(String message) {
        System.out.println(message);
        System.out.flush();
    }
}

