/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.group;

import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupProfile;
import com.okta.sdk.resource.group.GroupType;
import com.okta.sdk.resource.role.AssignRoleRequest;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.UserList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * Group
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2023-07-07T08:49:59.755-05:00")
public interface Group extends ExtensibleResource, Deletable {

    Map<String, Object> getEmbedded();

    Map<String, Object> getLinks();

    Date getCreated();

    String getId();

    Date getLastMembershipUpdated();

    Date getLastUpdated();

    List<String> getObjectClass();

    GroupProfile getProfile();

    Group setProfile(GroupProfile profile);

    GroupType getType();


    /**
    * 
    * Assigns a Role to a Group
    * @param assignRoleRequest  (required)
    * @param disableNotifications  (optional)
    * @return Role
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "POST - /api/v1/groups/{groupId}/roles")
    Role assignRole(AssignRoleRequest assignRoleRequest, Boolean disableNotifications);

    /**
    * 
    * Assigns a Role to a Group
    * @param assignRoleRequest  (required)
    * @return Role
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "POST - /api/v1/groups/{groupId}/roles")
    Role assignRole(AssignRoleRequest assignRoleRequest);

    /**
    * List Group Members
    * Enumerates all users that are a member of a group.
    * @return UserList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "GET - /api/v1/groups/{groupId}/users")
    UserList listUsers();


    /**
    * Update Group
    * Updates the profile for a group with &#x60;OKTA_GROUP&#x60; type from your organization.
    * @return Group
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "PUT - /api/v1/groups/{groupId}")
    Group update();


    /**
    * Remove User from Group
    * Removes a user from a group with &#39;OKTA_GROUP&#39; type.
    * @param userId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "DELETE - /api/v1/groups/{groupId}/users/{userId}")
    void removeUser(String userId);


    /**
    * List Assigned Applications
    * Enumerates all applications that are assigned to a group.
    * @return ApplicationList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "GET - /api/v1/groups/{groupId}/apps")
    ApplicationList listApplications();


    /**
    * Remove Group
    * Removes a group with &#x60;OKTA_GROUP&#x60; type from your organization.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2023-07-07T08:49:59.755-05:00",
            comments = "DELETE - /api/v1/groups/{groupId}")
    void delete();


}

