/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.WebAuthnRpIdDomain;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The [RP ID](https://www.w3.org/TR/webauthn/#relying-party-identifier) object for WebAuthn configuration")
@JsonPropertyOrder(value={"domain", "enabled"})
public class WebAuthnRpId
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private WebAuthnRpIdDomain domain;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = false;

    public WebAuthnRpId domain(WebAuthnRpIdDomain domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WebAuthnRpIdDomain getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(WebAuthnRpIdDomain domain) {
        this.domain = domain;
    }

    public WebAuthnRpId enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the RP ID is active and is used for WebAuthn operations. It can only be set to `true` once the `validationStatus` of the `domain` object is `VERIFIED`. `enabled` can only be `true` for this same `domain`. Its value must be `false` to be able to configure the `domain`.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAuthnRpId webAuthnRpId = (WebAuthnRpId)o;
        return Objects.equals(this.domain, webAuthnRpId.domain) && Objects.equals(this.enabled, webAuthnRpId.enabled);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.enabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebAuthnRpId {\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

