/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.UserSchemaBaseProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="All Okta-defined profile properties are defined in a profile subschema with the resolution scope `#base`. You can't modify these properties, except to update permissions, to change the nullability of `firstName` and `lastName`, or to specify a pattern for `login`. They can't be removed.  The base user profile is based on the [System for Cross-domain Identity Management: Core Schema](https://tools.ietf.org/html/draft-ietf-scim-core-schema-22#section-4.1.1) and has the standard properties detailed below.")
@JsonPropertyOrder(value={"id", "properties", "required", "type"})
public class UserSchemaBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private UserSchemaBaseProperties properties;
    public static final String JSON_PROPERTY_REQUIRED = "required";
    private List<String> required = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    @Nullable
    @ApiModelProperty(value="The subschema name")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public UserSchemaBase properties(UserSchemaBaseProperties properties) {
        this.properties = properties;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `#base` object properties")
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserSchemaBaseProperties getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(UserSchemaBaseProperties properties) {
        this.properties = properties;
    }

    @Nullable
    @ApiModelProperty(value="A collection indicating required property names")
    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRequired() {
        return this.required;
    }

    @Nullable
    @ApiModelProperty(value="The object type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSchemaBase userSchemaBase = (UserSchemaBase)o;
        return Objects.equals(this.id, userSchemaBase.id) && Objects.equals(this.properties, userSchemaBase.properties) && Objects.equals(this.required, userSchemaBase.required) && Objects.equals(this.type, userSchemaBase.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.properties, this.required, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSchemaBase {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

