/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserFactorLinks;
import com.okta.sdk.resource.model.UserFactorProvider;
import com.okta.sdk.resource.model.UserFactorStatus;
import com.okta.sdk.resource.model.UserFactorType;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"enrollment", "factorType", "provider", "status", "vendorName", "_embedded", "_links"})
public class UserFactorSupported
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ENROLLMENT = "enrollment";
    private EnrollmentEnum enrollment;
    public static final String JSON_PROPERTY_FACTOR_TYPE = "factorType";
    private UserFactorType factorType;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private UserFactorProvider provider;
    public static final String JSON_PROPERTY_STATUS = "status";
    private UserFactorStatus status;
    public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
    private String vendorName;
    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserFactorLinks links;

    public UserFactorSupported enrollment(EnrollmentEnum enrollment) {
        this.enrollment = enrollment;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="OPTIONAL", value="Indicates if the factor is required for the specified user")
    @JsonProperty(value="enrollment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EnrollmentEnum getEnrollment() {
        return this.enrollment;
    }

    @JsonProperty(value="enrollment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnrollment(EnrollmentEnum enrollment) {
        this.enrollment = enrollment;
    }

    public UserFactorSupported factorType(UserFactorType factorType) {
        this.factorType = factorType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="factorType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorType getFactorType() {
        return this.factorType;
    }

    @JsonProperty(value="factorType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFactorType(UserFactorType factorType) {
        this.factorType = factorType;
    }

    public UserFactorSupported provider(UserFactorProvider provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorProvider getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(UserFactorProvider provider) {
        this.provider = provider;
    }

    public UserFactorSupported status(UserFactorStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(UserFactorStatus status) {
        this.status = status;
    }

    @Nullable
    @ApiModelProperty(example="OKTA", value="Name of the factor vendor. This is usually the same as the provider except for On-Prem MFA, which depends on admin settings.")
    @JsonProperty(value="vendorName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVendorName() {
        return this.vendorName;
    }

    @Nullable
    @ApiModelProperty(value="Embedded resources related to the factor")
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getEmbedded() {
        return this.embedded;
    }

    public UserFactorSupported links(UserFactorLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserFactorLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFactorSupported userFactorSupported = (UserFactorSupported)o;
        return Objects.equals((Object)this.enrollment, (Object)userFactorSupported.enrollment) && Objects.equals((Object)this.factorType, (Object)userFactorSupported.factorType) && Objects.equals((Object)this.provider, (Object)userFactorSupported.provider) && Objects.equals((Object)this.status, (Object)userFactorSupported.status) && Objects.equals(this.vendorName, userFactorSupported.vendorName) && Objects.equals(this.embedded, userFactorSupported.embedded) && Objects.equals(this.links, userFactorSupported.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enrollment, this.factorType, this.provider, this.status, this.vendorName, this.embedded, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorSupported {\n");
        sb.append("    enrollment: ").append(this.toIndentedString((Object)this.enrollment)).append("\n");
        sb.append("    factorType: ").append(this.toIndentedString((Object)this.factorType)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    vendorName: ").append(this.toIndentedString(this.vendorName)).append("\n");
        sb.append("    embedded: ").append(this.toIndentedString(this.embedded)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EnrollmentEnum {
        OPTIONAL(String.valueOf("OPTIONAL")),
        REQUIRED(String.valueOf("REQUIRED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private EnrollmentEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EnrollmentEnum fromValue(String value) {
            for (EnrollmentEnum b : EnrollmentEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

