/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.HrefObject;
import com.okta.sdk.resource.model.HrefObjectSelfLink;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"activate", "cancel", "deactivate", "enroll", "factor", "poll", "qrcode", "question", "resend", "send", "self", "user", "verify"})
public class UserFactorLinks
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACTIVATE = "activate";
    private HrefObject activate;
    public static final String JSON_PROPERTY_CANCEL = "cancel";
    private HrefObject cancel;
    public static final String JSON_PROPERTY_DEACTIVATE = "deactivate";
    private HrefObject deactivate;
    public static final String JSON_PROPERTY_ENROLL = "enroll";
    private HrefObject enroll;
    public static final String JSON_PROPERTY_FACTOR = "factor";
    private HrefObject factor;
    public static final String JSON_PROPERTY_POLL = "poll";
    private HrefObject poll;
    public static final String JSON_PROPERTY_QRCODE = "qrcode";
    private HrefObject qrcode;
    public static final String JSON_PROPERTY_QUESTION = "question";
    private HrefObject question;
    public static final String JSON_PROPERTY_RESEND = "resend";
    private HrefObject resend;
    public static final String JSON_PROPERTY_SEND = "send";
    private HrefObject send;
    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObjectSelfLink self;
    public static final String JSON_PROPERTY_USER = "user";
    private HrefObject user;
    public static final String JSON_PROPERTY_VERIFY = "verify";
    private HrefObject verify;

    public UserFactorLinks activate(HrefObject activate) {
        this.activate = activate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Activates an enrolled factor. See [Activate a factor](/openapi/okta-management/management/tag/UserFactor/#tag/UserFactor/operation/activateFactor).")
    @JsonProperty(value="activate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getActivate() {
        return this.activate;
    }

    @JsonProperty(value="activate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActivate(HrefObject activate) {
        this.activate = activate;
    }

    public UserFactorLinks cancel(HrefObject cancel) {
        this.cancel = cancel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cancels a `push` factor challenge with a `WAITING` status")
    @JsonProperty(value="cancel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getCancel() {
        return this.cancel;
    }

    @JsonProperty(value="cancel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancel(HrefObject cancel) {
        this.cancel = cancel;
    }

    public UserFactorLinks deactivate(HrefObject deactivate) {
        this.deactivate = deactivate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deactivates the factor. See [Unenroll a factor](/openapi/okta-management/management/tag/UserFactor/#tag/UserFactor/operation/unenrollFactor).")
    @JsonProperty(value="deactivate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getDeactivate() {
        return this.deactivate;
    }

    @JsonProperty(value="deactivate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeactivate(HrefObject deactivate) {
        this.deactivate = deactivate;
    }

    public UserFactorLinks enroll(HrefObject enroll) {
        this.enroll = enroll;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Enrolls a supported factor. See [Enroll a factor](/openapi/okta-management/management/tag/UserFactor/#tag/UserFactor/operation/enrollFactor).")
    @JsonProperty(value="enroll")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getEnroll() {
        return this.enroll;
    }

    @JsonProperty(value="enroll")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnroll(HrefObject enroll) {
        this.enroll = enroll;
    }

    public UserFactorLinks factor(HrefObject factor) {
        this.factor = factor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Link to the factor resource")
    @JsonProperty(value="factor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getFactor() {
        return this.factor;
    }

    @JsonProperty(value="factor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFactor(HrefObject factor) {
        this.factor = factor;
    }

    public UserFactorLinks poll(HrefObject poll) {
        this.poll = poll;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Polls the factor resource for status information. Always use the `poll` link instead of manually constructing your own URL.")
    @JsonProperty(value="poll")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getPoll() {
        return this.poll;
    }

    @JsonProperty(value="poll")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPoll(HrefObject poll) {
        this.poll = poll;
    }

    public UserFactorLinks qrcode(HrefObject qrcode) {
        this.qrcode = qrcode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="QR code that encodes the push activation code needed for enrollment on the device")
    @JsonProperty(value="qrcode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getQrcode() {
        return this.qrcode;
    }

    @JsonProperty(value="qrcode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQrcode(HrefObject qrcode) {
        this.qrcode = qrcode;
    }

    public UserFactorLinks question(HrefObject question) {
        this.question = question;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Lists all supported security questions. See [List all supported security questions](/openapi/okta-management/management/tag/UserFactor/#tag/UserFactor/operation/listSupportedSecurityQuestions).")
    @JsonProperty(value="question")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getQuestion() {
        return this.question;
    }

    @JsonProperty(value="question")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuestion(HrefObject question) {
        this.question = question;
    }

    public UserFactorLinks resend(HrefObject resend) {
        this.resend = resend;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resends the factor enrollment challenge. See [Resend a factor enrollment](/openapi/okta-management/management/tag/UserFactor/#tag/UserFactor/operation/resendEnrollFactor).")
    @JsonProperty(value="resend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getResend() {
        return this.resend;
    }

    @JsonProperty(value="resend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResend(HrefObject resend) {
        this.resend = resend;
    }

    public UserFactorLinks send(HrefObject send) {
        this.send = send;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sends an activation link through email or sms for users who can't scan the QR code")
    @JsonProperty(value="send")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getSend() {
        return this.send;
    }

    @JsonProperty(value="send")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSend(HrefObject send) {
        this.send = send;
    }

    public UserFactorLinks self(HrefObjectSelfLink self) {
        this.self = self;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="self")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObjectSelfLink getSelf() {
        return this.self;
    }

    @JsonProperty(value="self")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObjectSelfLink self) {
        this.self = self;
    }

    public UserFactorLinks user(HrefObject user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Returns information on the specified user")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUser(HrefObject user) {
        this.user = user;
    }

    public UserFactorLinks verify(HrefObject verify) {
        this.verify = verify;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Verifies the factor resource. See [Verify a factor](/openapi/okta-management/management/tag/UserFactor/#tag/UserFactor/operation/verifyFactor).")
    @JsonProperty(value="verify")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getVerify() {
        return this.verify;
    }

    @JsonProperty(value="verify")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerify(HrefObject verify) {
        this.verify = verify;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFactorLinks userFactorLinks = (UserFactorLinks)o;
        return Objects.equals(this.activate, userFactorLinks.activate) && Objects.equals(this.cancel, userFactorLinks.cancel) && Objects.equals(this.deactivate, userFactorLinks.deactivate) && Objects.equals(this.enroll, userFactorLinks.enroll) && Objects.equals(this.factor, userFactorLinks.factor) && Objects.equals(this.poll, userFactorLinks.poll) && Objects.equals(this.qrcode, userFactorLinks.qrcode) && Objects.equals(this.question, userFactorLinks.question) && Objects.equals(this.resend, userFactorLinks.resend) && Objects.equals(this.send, userFactorLinks.send) && Objects.equals(this.self, userFactorLinks.self) && Objects.equals(this.user, userFactorLinks.user) && Objects.equals(this.verify, userFactorLinks.verify);
    }

    public int hashCode() {
        return Objects.hash(this.activate, this.cancel, this.deactivate, this.enroll, this.factor, this.poll, this.qrcode, this.question, this.resend, this.send, this.self, this.user, this.verify);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorLinks {\n");
        sb.append("    activate: ").append(this.toIndentedString(this.activate)).append("\n");
        sb.append("    cancel: ").append(this.toIndentedString(this.cancel)).append("\n");
        sb.append("    deactivate: ").append(this.toIndentedString(this.deactivate)).append("\n");
        sb.append("    enroll: ").append(this.toIndentedString(this.enroll)).append("\n");
        sb.append("    factor: ").append(this.toIndentedString(this.factor)).append("\n");
        sb.append("    poll: ").append(this.toIndentedString(this.poll)).append("\n");
        sb.append("    qrcode: ").append(this.toIndentedString(this.qrcode)).append("\n");
        sb.append("    question: ").append(this.toIndentedString(this.question)).append("\n");
        sb.append("    resend: ").append(this.toIndentedString(this.resend)).append("\n");
        sb.append("    send: ").append(this.toIndentedString(this.send)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    verify: ").append(this.toIndentedString(this.verify)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

