/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.okta.sdk.resource.model.BaseTokenToken;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Provides information on the properties of the access token that Okta has generated, including the existing claims that it contains")
@JsonPropertyOrder(value={"claims", "token", "scopes"})
@JsonTypeName(value="TokenPayLoad_data_access")
public class TokenPayLoadDataAccess
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLAIMS = "claims";
    private Object claims;
    public static final String JSON_PROPERTY_TOKEN = "token";
    private BaseTokenToken token;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private Object scopes;

    public TokenPayLoadDataAccess claims(Object claims) {
        this.claims = claims;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Claims included in the token. Consists of name-value pairs for each included claim. For descriptions of the claims that you can include, see the Okta [OpenID Connect and OAuth 2.0 API reference](/openapi/okta-oauth/guides/overview/#claims).")
    @JsonProperty(value="claims")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getClaims() {
        return this.claims;
    }

    @JsonProperty(value="claims")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClaims(Object claims) {
        this.claims = claims;
    }

    public TokenPayLoadDataAccess token(BaseTokenToken token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BaseTokenToken getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setToken(BaseTokenToken token) {
        this.token = token;
    }

    public TokenPayLoadDataAccess scopes(Object scopes) {
        this.scopes = scopes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The scopes contained in the token. For descriptions of the scopes that you can include, see the Okta [OpenID Connect and OAuth 2.0 API reference](/openapi/okta-oauth/guides/overview/#scopes).")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(Object scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenPayLoadDataAccess tokenPayLoadDataAccess = (TokenPayLoadDataAccess)o;
        return Objects.equals(this.claims, tokenPayLoadDataAccess.claims) && Objects.equals(this.token, tokenPayLoadDataAccess.token) && Objects.equals(this.scopes, tokenPayLoadDataAccess.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.claims, this.token, this.scopes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenPayLoadDataAccess {\n");
        sb.append("    claims: ").append(this.toIndentedString(this.claims)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

