/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.TelephonyRequestData;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"data", "eventType", "requestType", "source"})
public class TelephonyRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DATA = "data";
    private TelephonyRequestData data;
    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    private String eventType;
    public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
    private String requestType;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private String source;

    public TelephonyRequest data(TelephonyRequestData data) {
        this.data = data;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TelephonyRequestData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(TelephonyRequestData data) {
        this.data = data;
    }

    public TelephonyRequest eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of inline hook. The telephony inline hook type is `com.okta.telephony.provider`.")
    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public TelephonyRequest requestType(String requestType) {
        this.requestType = requestType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of inline hook request. For example, `com.okta.user.telephony.pre-enrollment`.")
    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestType() {
        return this.requestType;
    }

    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public TelephonyRequest source(String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID and URL of the telephony inline hook")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelephonyRequest telephonyRequest = (TelephonyRequest)o;
        return Objects.equals(this.data, telephonyRequest.data) && Objects.equals(this.eventType, telephonyRequest.eventType) && Objects.equals(this.requestType, telephonyRequest.requestType) && Objects.equals(this.source, telephonyRequest.source);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.eventType, this.requestType, this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelephonyRequest {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString(this.requestType)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

