/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Status corresponding to the `stream_id` of the SSF Stream")
@JsonPropertyOrder(value={"status", "stream_id"})
public class StreamStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_STREAM_ID = "stream_id";
    private String streamId;

    public StreamStatus status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The status of the SSF Stream configuration")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public StreamStatus streamId(String streamId) {
        this.streamId = streamId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="esc1k235GIIztAuGK0g5", value="The ID of the SSF Stream configuration. This corresponds to the value in the query parameter of the request.")
    @JsonProperty(value="stream_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStreamId() {
        return this.streamId;
    }

    @JsonProperty(value="stream_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamStatus streamStatus = (StreamStatus)o;
        return Objects.equals((Object)this.status, (Object)streamStatus.status) && Objects.equals(this.streamId, streamStatus.streamId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.streamId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StreamStatus {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    streamId: ").append(this.toIndentedString(this.streamId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ENABLED(String.valueOf("enabled")),
        DISABLED(String.valueOf("disabled")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

