/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdentityAssertionAppInstanceConnectionCreatableApp;
import com.okta.sdk.resource.model.STSServiceAccountConnectionCreatableServiceAccount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Create an STS connection for a service account")
@JsonPropertyOrder(value={"app", "connectionType", "protocolType", "resourceIndicator", "serviceAccount"})
public class STSServiceAccountConnectionCreatable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APP = "app";
    private IdentityAssertionAppInstanceConnectionCreatableApp app;
    public static final String JSON_PROPERTY_CONNECTION_TYPE = "connectionType";
    private ConnectionTypeEnum connectionType;
    public static final String JSON_PROPERTY_PROTOCOL_TYPE = "protocolType";
    private ProtocolTypeEnum protocolType;
    public static final String JSON_PROPERTY_RESOURCE_INDICATOR = "resourceIndicator";
    private URI resourceIndicator;
    public static final String JSON_PROPERTY_SERVICE_ACCOUNT = "serviceAccount";
    private STSServiceAccountConnectionCreatableServiceAccount serviceAccount;

    public STSServiceAccountConnectionCreatable app(IdentityAssertionAppInstanceConnectionCreatableApp app) {
        this.app = app;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="app")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IdentityAssertionAppInstanceConnectionCreatableApp getApp() {
        return this.app;
    }

    @JsonProperty(value="app")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApp(IdentityAssertionAppInstanceConnectionCreatableApp app) {
        this.app = app;
    }

    public STSServiceAccountConnectionCreatable connectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Type of connection authentication method")
    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConnectionTypeEnum getConnectionType() {
        return this.connectionType;
    }

    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
    }

    public STSServiceAccountConnectionCreatable protocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authentication protocol type used for the connection")
    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolTypeEnum getProtocolType() {
        return this.protocolType;
    }

    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProtocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
    }

    public STSServiceAccountConnectionCreatable resourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resource indicator used when requesting tokens. Defaults to the service account's ORN if not specified.")
    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getResourceIndicator() {
        return this.resourceIndicator;
    }

    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
    }

    public STSServiceAccountConnectionCreatable serviceAccount(STSServiceAccountConnectionCreatableServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="serviceAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public STSServiceAccountConnectionCreatableServiceAccount getServiceAccount() {
        return this.serviceAccount;
    }

    @JsonProperty(value="serviceAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceAccount(STSServiceAccountConnectionCreatableServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        STSServiceAccountConnectionCreatable stSServiceAccountConnectionCreatable = (STSServiceAccountConnectionCreatable)o;
        return Objects.equals(this.app, stSServiceAccountConnectionCreatable.app) && Objects.equals((Object)this.connectionType, (Object)stSServiceAccountConnectionCreatable.connectionType) && Objects.equals((Object)this.protocolType, (Object)stSServiceAccountConnectionCreatable.protocolType) && Objects.equals(this.resourceIndicator, stSServiceAccountConnectionCreatable.resourceIndicator) && Objects.equals(this.serviceAccount, stSServiceAccountConnectionCreatable.serviceAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.app, this.connectionType, this.protocolType, this.resourceIndicator, this.serviceAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class STSServiceAccountConnectionCreatable {\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    connectionType: ").append(this.toIndentedString((Object)this.connectionType)).append("\n");
        sb.append("    protocolType: ").append(this.toIndentedString((Object)this.protocolType)).append("\n");
        sb.append("    resourceIndicator: ").append(this.toIndentedString(this.resourceIndicator)).append("\n");
        sb.append("    serviceAccount: ").append(this.toIndentedString(this.serviceAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ConnectionTypeEnum {
        STS_SERVICE_ACCOUNT(String.valueOf("STS_SERVICE_ACCOUNT")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ConnectionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConnectionTypeEnum fromValue(String value) {
            for (ConnectionTypeEnum b : ConnectionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum ProtocolTypeEnum {
        STS(String.valueOf("STS")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ProtocolTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolTypeEnum fromValue(String value) {
            for (ProtocolTypeEnum b : ProtocolTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

