/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GrantType;
import com.okta.sdk.resource.model.IdTokenKeyEncryptionAlgorithm;
import com.okta.sdk.resource.model.OAuthResponseType;
import com.okta.sdk.resource.model.OpenIdConnectApplicationConsentMethod;
import com.okta.sdk.resource.model.OpenIdConnectApplicationIdpInitiatedLogin;
import com.okta.sdk.resource.model.OpenIdConnectApplicationIssuerMode;
import com.okta.sdk.resource.model.OpenIdConnectApplicationNetwork;
import com.okta.sdk.resource.model.OpenIdConnectApplicationSettingsClientKeys;
import com.okta.sdk.resource.model.OpenIdConnectApplicationSettingsRefreshToken;
import com.okta.sdk.resource.model.OpenIdConnectApplicationType;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"application_type", "backchannel_authentication_request_signing_alg", "backchannel_custom_authenticator_id", "backchannel_token_delivery_mode", "client_uri", "consent_method", "dpop_bound_access_tokens", "frontchannel_logout_session_required", "frontchannel_logout_uri", "grant_types", "id_token_encrypted_response_alg", "idp_initiated_login", "initiate_login_uri", "issuer_mode", "jwks", "jwks_uri", "logo_uri", "network", "participate_slo", "policy_uri", "post_logout_redirect_uris", "redirect_uris", "refresh_token", "request_object_signing_alg", "response_types", "sector_identifier_uri", "subject_type", "tos_uri", "wildcard_redirect"})
public class OpenIdConnectApplicationSettingsClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APPLICATION_TYPE = "application_type";
    private OpenIdConnectApplicationType applicationType;
    public static final String JSON_PROPERTY_BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG = "backchannel_authentication_request_signing_alg";
    private BackchannelAuthenticationRequestSigningAlgEnum backchannelAuthenticationRequestSigningAlg;
    public static final String JSON_PROPERTY_BACKCHANNEL_CUSTOM_AUTHENTICATOR_ID = "backchannel_custom_authenticator_id";
    private String backchannelCustomAuthenticatorId;
    public static final String JSON_PROPERTY_BACKCHANNEL_TOKEN_DELIVERY_MODE = "backchannel_token_delivery_mode";
    private BackchannelTokenDeliveryModeEnum backchannelTokenDeliveryMode;
    public static final String JSON_PROPERTY_CLIENT_URI = "client_uri";
    private String clientUri;
    public static final String JSON_PROPERTY_CONSENT_METHOD = "consent_method";
    private OpenIdConnectApplicationConsentMethod consentMethod = OpenIdConnectApplicationConsentMethod.TRUSTED;
    public static final String JSON_PROPERTY_DPOP_BOUND_ACCESS_TOKENS = "dpop_bound_access_tokens";
    private Boolean dpopBoundAccessTokens = false;
    public static final String JSON_PROPERTY_FRONTCHANNEL_LOGOUT_SESSION_REQUIRED = "frontchannel_logout_session_required";
    private Boolean frontchannelLogoutSessionRequired;
    public static final String JSON_PROPERTY_FRONTCHANNEL_LOGOUT_URI = "frontchannel_logout_uri";
    private String frontchannelLogoutUri;
    public static final String JSON_PROPERTY_GRANT_TYPES = "grant_types";
    private List<GrantType> grantTypes = new ArrayList<GrantType>();
    public static final String JSON_PROPERTY_ID_TOKEN_ENCRYPTED_RESPONSE_ALG = "id_token_encrypted_response_alg";
    private IdTokenKeyEncryptionAlgorithm idTokenEncryptedResponseAlg;
    public static final String JSON_PROPERTY_IDP_INITIATED_LOGIN = "idp_initiated_login";
    private OpenIdConnectApplicationIdpInitiatedLogin idpInitiatedLogin;
    public static final String JSON_PROPERTY_INITIATE_LOGIN_URI = "initiate_login_uri";
    private String initiateLoginUri;
    public static final String JSON_PROPERTY_ISSUER_MODE = "issuer_mode";
    private OpenIdConnectApplicationIssuerMode issuerMode;
    public static final String JSON_PROPERTY_JWKS = "jwks";
    private OpenIdConnectApplicationSettingsClientKeys jwks;
    public static final String JSON_PROPERTY_JWKS_URI = "jwks_uri";
    private String jwksUri;
    public static final String JSON_PROPERTY_LOGO_URI = "logo_uri";
    private String logoUri;
    public static final String JSON_PROPERTY_NETWORK = "network";
    private OpenIdConnectApplicationNetwork network;
    public static final String JSON_PROPERTY_PARTICIPATE_SLO = "participate_slo";
    private Boolean participateSlo;
    public static final String JSON_PROPERTY_POLICY_URI = "policy_uri";
    private String policyUri;
    public static final String JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS = "post_logout_redirect_uris";
    private List<String> postLogoutRedirectUris = null;
    public static final String JSON_PROPERTY_REDIRECT_URIS = "redirect_uris";
    private List<String> redirectUris = null;
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
    private OpenIdConnectApplicationSettingsRefreshToken refreshToken;
    public static final String JSON_PROPERTY_REQUEST_OBJECT_SIGNING_ALG = "request_object_signing_alg";
    private RequestObjectSigningAlgEnum requestObjectSigningAlg;
    public static final String JSON_PROPERTY_RESPONSE_TYPES = "response_types";
    private List<OAuthResponseType> responseTypes = null;
    public static final String JSON_PROPERTY_SECTOR_IDENTIFIER_URI = "sector_identifier_uri";
    private String sectorIdentifierUri;
    public static final String JSON_PROPERTY_SUBJECT_TYPE = "subject_type";
    private SubjectTypeEnum subjectType;
    public static final String JSON_PROPERTY_TOS_URI = "tos_uri";
    private String tosUri;
    public static final String JSON_PROPERTY_WILDCARD_REDIRECT = "wildcard_redirect";
    private WildcardRedirectEnum wildcardRedirect;

    public OpenIdConnectApplicationSettingsClient applicationType(OpenIdConnectApplicationType applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="application_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OpenIdConnectApplicationType getApplicationType() {
        return this.applicationType;
    }

    @JsonProperty(value="application_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationType(OpenIdConnectApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public OpenIdConnectApplicationSettingsClient backchannelAuthenticationRequestSigningAlg(BackchannelAuthenticationRequestSigningAlgEnum backchannelAuthenticationRequestSigningAlg) {
        this.backchannelAuthenticationRequestSigningAlg = backchannelAuthenticationRequestSigningAlg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The signing algorithm for Client-Initiated Backchannel Authentication (CIBA) signed requests using JWT. If this value isn't set and a JWT-signed request is sent, the request fails. > **Note:** This property appears for clients with `urn:openid:params:grant-type:ciba` defined as one of the `grant_types`. ")
    @JsonProperty(value="backchannel_authentication_request_signing_alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BackchannelAuthenticationRequestSigningAlgEnum getBackchannelAuthenticationRequestSigningAlg() {
        return this.backchannelAuthenticationRequestSigningAlg;
    }

    @JsonProperty(value="backchannel_authentication_request_signing_alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBackchannelAuthenticationRequestSigningAlg(BackchannelAuthenticationRequestSigningAlgEnum backchannelAuthenticationRequestSigningAlg) {
        this.backchannelAuthenticationRequestSigningAlg = backchannelAuthenticationRequestSigningAlg;
    }

    public OpenIdConnectApplicationSettingsClient backchannelCustomAuthenticatorId(String backchannelCustomAuthenticatorId) {
        this.backchannelCustomAuthenticatorId = backchannelCustomAuthenticatorId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the custom authenticator that authenticates the user > **Note:** This property appears for clients with `urn:openid:params:grant-type:ciba` defined as one of the `grant_types`. ")
    @JsonProperty(value="backchannel_custom_authenticator_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBackchannelCustomAuthenticatorId() {
        return this.backchannelCustomAuthenticatorId;
    }

    @JsonProperty(value="backchannel_custom_authenticator_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBackchannelCustomAuthenticatorId(String backchannelCustomAuthenticatorId) {
        this.backchannelCustomAuthenticatorId = backchannelCustomAuthenticatorId;
    }

    public OpenIdConnectApplicationSettingsClient backchannelTokenDeliveryMode(BackchannelTokenDeliveryModeEnum backchannelTokenDeliveryMode) {
        this.backchannelTokenDeliveryMode = backchannelTokenDeliveryMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The delivery mode for Client-Initiated Backchannel Authentication (CIBA).  Currently, only `poll` is supported. > **Note:** This property appears for clients with `urn:openid:params:grant-type:ciba` defined as one of the `grant_types`. ")
    @JsonProperty(value="backchannel_token_delivery_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BackchannelTokenDeliveryModeEnum getBackchannelTokenDeliveryMode() {
        return this.backchannelTokenDeliveryMode;
    }

    @JsonProperty(value="backchannel_token_delivery_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBackchannelTokenDeliveryMode(BackchannelTokenDeliveryModeEnum backchannelTokenDeliveryMode) {
        this.backchannelTokenDeliveryMode = backchannelTokenDeliveryMode;
    }

    public OpenIdConnectApplicationSettingsClient clientUri(String clientUri) {
        this.clientUri = clientUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL string of a web page providing information about the client")
    @JsonProperty(value="client_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientUri() {
        return this.clientUri;
    }

    @JsonProperty(value="client_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    public OpenIdConnectApplicationSettingsClient consentMethod(OpenIdConnectApplicationConsentMethod consentMethod) {
        this.consentMethod = consentMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="consent_method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OpenIdConnectApplicationConsentMethod getConsentMethod() {
        return this.consentMethod;
    }

    @JsonProperty(value="consent_method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConsentMethod(OpenIdConnectApplicationConsentMethod consentMethod) {
        this.consentMethod = consentMethod;
    }

    public OpenIdConnectApplicationSettingsClient dpopBoundAccessTokens(Boolean dpopBoundAccessTokens) {
        this.dpopBoundAccessTokens = dpopBoundAccessTokens;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates that the client application uses Demonstrating Proof-of-Possession (DPoP) for token requests. If `true`, the authorization server rejects token requests from this client that don't contain the DPoP header. > **Note:** If `dpop_bound_access_tokens` is true, then `client_credentials` and `implicit` aren't allowed in `grant_types`. ")
    @JsonProperty(value="dpop_bound_access_tokens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDpopBoundAccessTokens() {
        return this.dpopBoundAccessTokens;
    }

    @JsonProperty(value="dpop_bound_access_tokens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDpopBoundAccessTokens(Boolean dpopBoundAccessTokens) {
        this.dpopBoundAccessTokens = dpopBoundAccessTokens;
    }

    public OpenIdConnectApplicationSettingsClient frontchannelLogoutSessionRequired(Boolean frontchannelLogoutSessionRequired) {
        this.frontchannelLogoutSessionRequired = frontchannelLogoutSessionRequired;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="<x-lifecycle-container><x-lifecycle class=\"ea\"></x-lifecycle> <x-lifecycle class=\"oie\"></x-lifecycle></x-lifecycle-container>Determines whether Okta sends `sid` and `iss` in the logout request")
    @JsonProperty(value="frontchannel_logout_session_required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFrontchannelLogoutSessionRequired() {
        return this.frontchannelLogoutSessionRequired;
    }

    @JsonProperty(value="frontchannel_logout_session_required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFrontchannelLogoutSessionRequired(Boolean frontchannelLogoutSessionRequired) {
        this.frontchannelLogoutSessionRequired = frontchannelLogoutSessionRequired;
    }

    public OpenIdConnectApplicationSettingsClient frontchannelLogoutUri(String frontchannelLogoutUri) {
        this.frontchannelLogoutUri = frontchannelLogoutUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="<x-lifecycle-container><x-lifecycle class=\"ea\"></x-lifecycle> <x-lifecycle class=\"oie\"></x-lifecycle></x-lifecycle-container>URL where Okta sends the logout request")
    @JsonProperty(value="frontchannel_logout_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFrontchannelLogoutUri() {
        return this.frontchannelLogoutUri;
    }

    @JsonProperty(value="frontchannel_logout_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFrontchannelLogoutUri(String frontchannelLogoutUri) {
        this.frontchannelLogoutUri = frontchannelLogoutUri;
    }

    public OpenIdConnectApplicationSettingsClient grantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public OpenIdConnectApplicationSettingsClient addgrantTypesItem(GrantType grantTypesItem) {
        if (this.grantTypes == null) {
            this.grantTypes = new ArrayList<GrantType>();
        }
        this.grantTypes.add(grantTypesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="grant_types")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    @JsonProperty(value="grant_types")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGrantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public OpenIdConnectApplicationSettingsClient idTokenEncryptedResponseAlg(IdTokenKeyEncryptionAlgorithm idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = idTokenEncryptedResponseAlg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="id_token_encrypted_response_alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IdTokenKeyEncryptionAlgorithm getIdTokenEncryptedResponseAlg() {
        return this.idTokenEncryptedResponseAlg;
    }

    @JsonProperty(value="id_token_encrypted_response_alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdTokenEncryptedResponseAlg(IdTokenKeyEncryptionAlgorithm idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = idTokenEncryptedResponseAlg;
    }

    public OpenIdConnectApplicationSettingsClient idpInitiatedLogin(OpenIdConnectApplicationIdpInitiatedLogin idpInitiatedLogin) {
        this.idpInitiatedLogin = idpInitiatedLogin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="idp_initiated_login")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OpenIdConnectApplicationIdpInitiatedLogin getIdpInitiatedLogin() {
        return this.idpInitiatedLogin;
    }

    @JsonProperty(value="idp_initiated_login")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdpInitiatedLogin(OpenIdConnectApplicationIdpInitiatedLogin idpInitiatedLogin) {
        this.idpInitiatedLogin = idpInitiatedLogin;
    }

    public OpenIdConnectApplicationSettingsClient initiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL string that a third party can use to initiate the sign-in flow by the client")
    @JsonProperty(value="initiate_login_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    @JsonProperty(value="initiate_login_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public OpenIdConnectApplicationSettingsClient issuerMode(OpenIdConnectApplicationIssuerMode issuerMode) {
        this.issuerMode = issuerMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="issuer_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OpenIdConnectApplicationIssuerMode getIssuerMode() {
        return this.issuerMode;
    }

    @JsonProperty(value="issuer_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerMode(OpenIdConnectApplicationIssuerMode issuerMode) {
        this.issuerMode = issuerMode;
    }

    public OpenIdConnectApplicationSettingsClient jwks(OpenIdConnectApplicationSettingsClientKeys jwks) {
        this.jwks = jwks;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="jwks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OpenIdConnectApplicationSettingsClientKeys getJwks() {
        return this.jwks;
    }

    @JsonProperty(value="jwks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJwks(OpenIdConnectApplicationSettingsClientKeys jwks) {
        this.jwks = jwks;
    }

    public OpenIdConnectApplicationSettingsClient jwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL string that references a JSON Web Key Set for validating JWTs presented to Okta or for encrypting ID tokens minted by Okta for the client")
    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJwksUri() {
        return this.jwksUri;
    }

    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public OpenIdConnectApplicationSettingsClient logoUri(String logoUri) {
        this.logoUri = logoUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL string that references a logo for the client. This logo appears on the client tile in the End-User Dashboard. It also appears on the client consent dialog during the client consent flow.")
    @JsonProperty(value="logo_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogoUri() {
        return this.logoUri;
    }

    @JsonProperty(value="logo_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    public OpenIdConnectApplicationSettingsClient network(OpenIdConnectApplicationNetwork network) {
        this.network = network;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="network")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OpenIdConnectApplicationNetwork getNetwork() {
        return this.network;
    }

    @JsonProperty(value="network")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetwork(OpenIdConnectApplicationNetwork network) {
        this.network = network;
    }

    public OpenIdConnectApplicationSettingsClient participateSlo(Boolean participateSlo) {
        this.participateSlo = participateSlo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="<x-lifecycle-container><x-lifecycle class=\"ea\"></x-lifecycle> <x-lifecycle class=\"oie\"></x-lifecycle></x-lifecycle-container>Allows the app to participate in front-channel Single Logout  > **Note:** You can only enable `participate_slo` for `web` and `browser` application types (`application_type`). ")
    @JsonProperty(value="participate_slo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getParticipateSlo() {
        return this.participateSlo;
    }

    @JsonProperty(value="participate_slo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParticipateSlo(Boolean participateSlo) {
        this.participateSlo = participateSlo;
    }

    public OpenIdConnectApplicationSettingsClient policyUri(String policyUri) {
        this.policyUri = policyUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL string of a web page providing the client's policy document")
    @JsonProperty(value="policy_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPolicyUri() {
        return this.policyUri;
    }

    @JsonProperty(value="policy_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public OpenIdConnectApplicationSettingsClient postLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
        return this;
    }

    public OpenIdConnectApplicationSettingsClient addpostLogoutRedirectUrisItem(String postLogoutRedirectUrisItem) {
        if (this.postLogoutRedirectUris == null) {
            this.postLogoutRedirectUris = new ArrayList<String>();
        }
        this.postLogoutRedirectUris.add(postLogoutRedirectUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of redirection URI strings for relying party-initiated logouts")
    @JsonProperty(value="post_logout_redirect_uris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    @JsonProperty(value="post_logout_redirect_uris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public OpenIdConnectApplicationSettingsClient redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public OpenIdConnectApplicationSettingsClient addredirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of redirection URI strings for use in redirect-based flows. > **Note:** At least one `redirect_uris` and `response_types` are required for all client types, with exceptions: if the client uses the [Resource Owner Password ](https://tools.ietf.org/html/rfc6749#section-4.3)flow (`grant_types` contains `password`) or [Client Credentials](https://tools.ietf.org/html/rfc6749#section-4.4)flow (`grant_types` contains `client_credentials`), then no `redirect_uris` or `response_types` is necessary. In these cases, you can pass either null or an empty array for these attributes.")
    @JsonProperty(value="redirect_uris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    @JsonProperty(value="redirect_uris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public OpenIdConnectApplicationSettingsClient refreshToken(OpenIdConnectApplicationSettingsRefreshToken refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OpenIdConnectApplicationSettingsRefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefreshToken(OpenIdConnectApplicationSettingsRefreshToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    public OpenIdConnectApplicationSettingsClient requestObjectSigningAlg(RequestObjectSigningAlgEnum requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of JSON Web Key Set (JWKS) algorithm that must be used for signing request objects")
    @JsonProperty(value="request_object_signing_alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RequestObjectSigningAlgEnum getRequestObjectSigningAlg() {
        return this.requestObjectSigningAlg;
    }

    @JsonProperty(value="request_object_signing_alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestObjectSigningAlg(RequestObjectSigningAlgEnum requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public OpenIdConnectApplicationSettingsClient responseTypes(List<OAuthResponseType> responseTypes) {
        this.responseTypes = responseTypes;
        return this;
    }

    public OpenIdConnectApplicationSettingsClient addresponseTypesItem(OAuthResponseType responseTypesItem) {
        if (this.responseTypes == null) {
            this.responseTypes = new ArrayList<OAuthResponseType>();
        }
        this.responseTypes.add(responseTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of OAuth 2.0 response type strings")
    @JsonProperty(value="response_types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OAuthResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    @JsonProperty(value="response_types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponseTypes(List<OAuthResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public OpenIdConnectApplicationSettingsClient sectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sector identifier used for pairwise `subject_type`. See [OIDC Pairwise Identifier Algorithm](https://openid.net/specs/openid-connect-messages-1_0-20.html#idtype.pairwise.alg)")
    @JsonProperty(value="sector_identifier_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    @JsonProperty(value="sector_identifier_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public OpenIdConnectApplicationSettingsClient subjectType(SubjectTypeEnum subjectType) {
        this.subjectType = subjectType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of the subject")
    @JsonProperty(value="subject_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubjectTypeEnum getSubjectType() {
        return this.subjectType;
    }

    @JsonProperty(value="subject_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubjectType(SubjectTypeEnum subjectType) {
        this.subjectType = subjectType;
    }

    public OpenIdConnectApplicationSettingsClient tosUri(String tosUri) {
        this.tosUri = tosUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL string of a web page providing the client's terms of service document")
    @JsonProperty(value="tos_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTosUri() {
        return this.tosUri;
    }

    @JsonProperty(value="tos_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    public OpenIdConnectApplicationSettingsClient wildcardRedirect(WildcardRedirectEnum wildcardRedirect) {
        this.wildcardRedirect = wildcardRedirect;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the client is allowed to use wildcard matching of `redirect_uris`")
    @JsonProperty(value="wildcard_redirect")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WildcardRedirectEnum getWildcardRedirect() {
        return this.wildcardRedirect;
    }

    @JsonProperty(value="wildcard_redirect")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWildcardRedirect(WildcardRedirectEnum wildcardRedirect) {
        this.wildcardRedirect = wildcardRedirect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIdConnectApplicationSettingsClient openIdConnectApplicationSettingsClient = (OpenIdConnectApplicationSettingsClient)o;
        return Objects.equals((Object)this.applicationType, (Object)openIdConnectApplicationSettingsClient.applicationType) && Objects.equals((Object)this.backchannelAuthenticationRequestSigningAlg, (Object)openIdConnectApplicationSettingsClient.backchannelAuthenticationRequestSigningAlg) && Objects.equals(this.backchannelCustomAuthenticatorId, openIdConnectApplicationSettingsClient.backchannelCustomAuthenticatorId) && Objects.equals((Object)this.backchannelTokenDeliveryMode, (Object)openIdConnectApplicationSettingsClient.backchannelTokenDeliveryMode) && Objects.equals(this.clientUri, openIdConnectApplicationSettingsClient.clientUri) && Objects.equals((Object)this.consentMethod, (Object)openIdConnectApplicationSettingsClient.consentMethod) && Objects.equals(this.dpopBoundAccessTokens, openIdConnectApplicationSettingsClient.dpopBoundAccessTokens) && Objects.equals(this.frontchannelLogoutSessionRequired, openIdConnectApplicationSettingsClient.frontchannelLogoutSessionRequired) && Objects.equals(this.frontchannelLogoutUri, openIdConnectApplicationSettingsClient.frontchannelLogoutUri) && Objects.equals(this.grantTypes, openIdConnectApplicationSettingsClient.grantTypes) && Objects.equals((Object)this.idTokenEncryptedResponseAlg, (Object)openIdConnectApplicationSettingsClient.idTokenEncryptedResponseAlg) && Objects.equals(this.idpInitiatedLogin, openIdConnectApplicationSettingsClient.idpInitiatedLogin) && Objects.equals(this.initiateLoginUri, openIdConnectApplicationSettingsClient.initiateLoginUri) && Objects.equals((Object)this.issuerMode, (Object)openIdConnectApplicationSettingsClient.issuerMode) && Objects.equals(this.jwks, openIdConnectApplicationSettingsClient.jwks) && Objects.equals(this.jwksUri, openIdConnectApplicationSettingsClient.jwksUri) && Objects.equals(this.logoUri, openIdConnectApplicationSettingsClient.logoUri) && Objects.equals(this.network, openIdConnectApplicationSettingsClient.network) && Objects.equals(this.participateSlo, openIdConnectApplicationSettingsClient.participateSlo) && Objects.equals(this.policyUri, openIdConnectApplicationSettingsClient.policyUri) && Objects.equals(this.postLogoutRedirectUris, openIdConnectApplicationSettingsClient.postLogoutRedirectUris) && Objects.equals(this.redirectUris, openIdConnectApplicationSettingsClient.redirectUris) && Objects.equals(this.refreshToken, openIdConnectApplicationSettingsClient.refreshToken) && Objects.equals((Object)this.requestObjectSigningAlg, (Object)openIdConnectApplicationSettingsClient.requestObjectSigningAlg) && Objects.equals(this.responseTypes, openIdConnectApplicationSettingsClient.responseTypes) && Objects.equals(this.sectorIdentifierUri, openIdConnectApplicationSettingsClient.sectorIdentifierUri) && Objects.equals((Object)this.subjectType, (Object)openIdConnectApplicationSettingsClient.subjectType) && Objects.equals(this.tosUri, openIdConnectApplicationSettingsClient.tosUri) && Objects.equals((Object)this.wildcardRedirect, (Object)openIdConnectApplicationSettingsClient.wildcardRedirect);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.applicationType, this.backchannelAuthenticationRequestSigningAlg, this.backchannelCustomAuthenticatorId, this.backchannelTokenDeliveryMode, this.clientUri, this.consentMethod, this.dpopBoundAccessTokens, this.frontchannelLogoutSessionRequired, this.frontchannelLogoutUri, this.grantTypes, this.idTokenEncryptedResponseAlg, this.idpInitiatedLogin, this.initiateLoginUri, this.issuerMode, this.jwks, this.jwksUri, this.logoUri, this.network, this.participateSlo, this.policyUri, this.postLogoutRedirectUris, this.redirectUris, this.refreshToken, this.requestObjectSigningAlg, this.responseTypes, this.sectorIdentifierUri, this.subjectType, this.tosUri, this.wildcardRedirect});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIdConnectApplicationSettingsClient {\n");
        sb.append("    applicationType: ").append(this.toIndentedString((Object)this.applicationType)).append("\n");
        sb.append("    backchannelAuthenticationRequestSigningAlg: ").append(this.toIndentedString((Object)this.backchannelAuthenticationRequestSigningAlg)).append("\n");
        sb.append("    backchannelCustomAuthenticatorId: ").append(this.toIndentedString(this.backchannelCustomAuthenticatorId)).append("\n");
        sb.append("    backchannelTokenDeliveryMode: ").append(this.toIndentedString((Object)this.backchannelTokenDeliveryMode)).append("\n");
        sb.append("    clientUri: ").append(this.toIndentedString(this.clientUri)).append("\n");
        sb.append("    consentMethod: ").append(this.toIndentedString((Object)this.consentMethod)).append("\n");
        sb.append("    dpopBoundAccessTokens: ").append(this.toIndentedString(this.dpopBoundAccessTokens)).append("\n");
        sb.append("    frontchannelLogoutSessionRequired: ").append(this.toIndentedString(this.frontchannelLogoutSessionRequired)).append("\n");
        sb.append("    frontchannelLogoutUri: ").append(this.toIndentedString(this.frontchannelLogoutUri)).append("\n");
        sb.append("    grantTypes: ").append(this.toIndentedString(this.grantTypes)).append("\n");
        sb.append("    idTokenEncryptedResponseAlg: ").append(this.toIndentedString((Object)this.idTokenEncryptedResponseAlg)).append("\n");
        sb.append("    idpInitiatedLogin: ").append(this.toIndentedString(this.idpInitiatedLogin)).append("\n");
        sb.append("    initiateLoginUri: ").append(this.toIndentedString(this.initiateLoginUri)).append("\n");
        sb.append("    issuerMode: ").append(this.toIndentedString((Object)this.issuerMode)).append("\n");
        sb.append("    jwks: ").append(this.toIndentedString(this.jwks)).append("\n");
        sb.append("    jwksUri: ").append(this.toIndentedString(this.jwksUri)).append("\n");
        sb.append("    logoUri: ").append(this.toIndentedString(this.logoUri)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    participateSlo: ").append(this.toIndentedString(this.participateSlo)).append("\n");
        sb.append("    policyUri: ").append(this.toIndentedString(this.policyUri)).append("\n");
        sb.append("    postLogoutRedirectUris: ").append(this.toIndentedString(this.postLogoutRedirectUris)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    requestObjectSigningAlg: ").append(this.toIndentedString((Object)this.requestObjectSigningAlg)).append("\n");
        sb.append("    responseTypes: ").append(this.toIndentedString(this.responseTypes)).append("\n");
        sb.append("    sectorIdentifierUri: ").append(this.toIndentedString(this.sectorIdentifierUri)).append("\n");
        sb.append("    subjectType: ").append(this.toIndentedString((Object)this.subjectType)).append("\n");
        sb.append("    tosUri: ").append(this.toIndentedString(this.tosUri)).append("\n");
        sb.append("    wildcardRedirect: ").append(this.toIndentedString((Object)this.wildcardRedirect)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum BackchannelAuthenticationRequestSigningAlgEnum {
        HS256(String.valueOf("HS256")),
        HS384(String.valueOf("HS384")),
        HS512(String.valueOf("HS512")),
        RS256(String.valueOf("RS256")),
        RS384(String.valueOf("RS384")),
        RS512(String.valueOf("RS512")),
        ES256(String.valueOf("ES256")),
        ES384(String.valueOf("ES384")),
        ES512(String.valueOf("ES512")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private BackchannelAuthenticationRequestSigningAlgEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BackchannelAuthenticationRequestSigningAlgEnum fromValue(String value) {
            for (BackchannelAuthenticationRequestSigningAlgEnum b : BackchannelAuthenticationRequestSigningAlgEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum BackchannelTokenDeliveryModeEnum {
        POLL(String.valueOf("poll")),
        PING(String.valueOf("ping")),
        PUSH(String.valueOf("push")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private BackchannelTokenDeliveryModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BackchannelTokenDeliveryModeEnum fromValue(String value) {
            for (BackchannelTokenDeliveryModeEnum b : BackchannelTokenDeliveryModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum RequestObjectSigningAlgEnum {
        HS256(String.valueOf("HS256")),
        HS384(String.valueOf("HS384")),
        HS512(String.valueOf("HS512")),
        RS256(String.valueOf("RS256")),
        RS384(String.valueOf("RS384")),
        RS512(String.valueOf("RS512")),
        ES256(String.valueOf("ES256")),
        ES384(String.valueOf("ES384")),
        ES512(String.valueOf("ES512")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private RequestObjectSigningAlgEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestObjectSigningAlgEnum fromValue(String value) {
            for (RequestObjectSigningAlgEnum b : RequestObjectSigningAlgEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum SubjectTypeEnum {
        PUBLIC(String.valueOf("public")),
        PAIRWISE(String.valueOf("pairwise")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private SubjectTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubjectTypeEnum fromValue(String value) {
            for (SubjectTypeEnum b : SubjectTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum WildcardRedirectEnum {
        DISABLED(String.valueOf("DISABLED")),
        SUBDOMAIN(String.valueOf("SUBDOMAIN")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private WildcardRedirectEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WildcardRedirectEnum fromValue(String value) {
            for (WildcardRedirectEnum b : WildcardRedirectEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

