/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="The network restrictions of the client")
@JsonPropertyOrder(value={"connection", "exclude", "include"})
public class OpenIdConnectApplicationNetwork
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CONNECTION = "connection";
    private ConnectionEnum connection;
    public static final String JSON_PROPERTY_EXCLUDE = "exclude";
    private List<String> exclude = null;
    public static final String JSON_PROPERTY_INCLUDE = "include";
    private List<String> include = null;

    public OpenIdConnectApplicationNetwork connection(ConnectionEnum connection) {
        this.connection = connection;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The connection type of the network. Can be `ANYWHERE` or `ZONE`. ")
    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConnectionEnum getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConnection(ConnectionEnum connection) {
        this.connection = connection;
    }

    public OpenIdConnectApplicationNetwork exclude(List<String> exclude) {
        this.exclude = exclude;
        return this;
    }

    public OpenIdConnectApplicationNetwork addexcludeItem(String excludeItem) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<String>();
        }
        this.exclude.add(excludeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `ZONE` is specified as a connection, then specify the excluded IP network zones here. Value can be \"ALL_IP_ZONES\" or an array of zone IDs.")
    @JsonProperty(value="exclude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExclude() {
        return this.exclude;
    }

    @JsonProperty(value="exclude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
    }

    public OpenIdConnectApplicationNetwork include(List<String> include) {
        this.include = include;
        return this;
    }

    public OpenIdConnectApplicationNetwork addincludeItem(String includeItem) {
        if (this.include == null) {
            this.include = new ArrayList<String>();
        }
        this.include.add(includeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `ZONE` is specified as a connection, then specify the included IP network zones here. Value can be \"ALL_IP_ZONES\" or an array of zone IDs.")
    @JsonProperty(value="include")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getInclude() {
        return this.include;
    }

    @JsonProperty(value="include")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInclude(List<String> include) {
        this.include = include;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIdConnectApplicationNetwork openIdConnectApplicationNetwork = (OpenIdConnectApplicationNetwork)o;
        return Objects.equals((Object)this.connection, (Object)openIdConnectApplicationNetwork.connection) && Objects.equals(this.exclude, openIdConnectApplicationNetwork.exclude) && Objects.equals(this.include, openIdConnectApplicationNetwork.include);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connection, this.exclude, this.include});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIdConnectApplicationNetwork {\n");
        sb.append("    connection: ").append(this.toIndentedString((Object)this.connection)).append("\n");
        sb.append("    exclude: ").append(this.toIndentedString(this.exclude)).append("\n");
        sb.append("    include: ").append(this.toIndentedString(this.include)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ConnectionEnum {
        ANYWHERE(String.valueOf("ANYWHERE")),
        ZONE(String.valueOf("ZONE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ConnectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConnectionEnum fromValue(String value) {
            for (ConnectionEnum b : ConnectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

