/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Settings required for the Microsoft Office 365 provisioning connection")
@JsonPropertyOrder(value={"adminPassword", "adminUsername"})
public class Office365ProvisioningSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ADMIN_PASSWORD = "adminPassword";
    private String adminPassword;
    public static final String JSON_PROPERTY_ADMIN_USERNAME = "adminUsername";
    private String adminUsername;

    public Office365ProvisioningSettings adminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Microsoft Office 365 global administrator password")
    @JsonProperty(value="adminPassword")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAdminPassword() {
        return this.adminPassword;
    }

    @JsonProperty(value="adminPassword")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public Office365ProvisioningSettings adminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Microsoft Office 365 global administrator username")
    @JsonProperty(value="adminUsername")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAdminUsername() {
        return this.adminUsername;
    }

    @JsonProperty(value="adminUsername")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Office365ProvisioningSettings office365ProvisioningSettings = (Office365ProvisioningSettings)o;
        return Objects.equals(this.adminPassword, office365ProvisioningSettings.adminPassword) && Objects.equals(this.adminUsername, office365ProvisioningSettings.adminUsername);
    }

    public int hashCode() {
        return Objects.hash(this.adminPassword, this.adminUsername);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Office365ProvisioningSettings {\n");
        sb.append("    adminPassword: ").append(this.toIndentedString(this.adminPassword)).append("\n");
        sb.append("    adminUsername: ").append(this.toIndentedString(this.adminUsername)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

