/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="OAuth 2.0 configuration used for authType `OAUTH2`")
@JsonPropertyOrder(value={"authorizeEndpoint", "clientId", "clientSecret", "scopes", "tokenEndpoint"})
public class OAuth2Settings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHORIZE_ENDPOINT = "authorizeEndpoint";
    private URI authorizeEndpoint;
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "clientSecret";
    private String clientSecret;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;
    public static final String JSON_PROPERTY_TOKEN_ENDPOINT = "tokenEndpoint";
    private URI tokenEndpoint;

    public OAuth2Settings authorizeEndpoint(URI authorizeEndpoint) {
        this.authorizeEndpoint = authorizeEndpoint;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The URL to the authorization server's authorization endpoint")
    @JsonProperty(value="authorizeEndpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getAuthorizeEndpoint() {
        return this.authorizeEndpoint;
    }

    @JsonProperty(value="authorizeEndpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthorizeEndpoint(URI authorizeEndpoint) {
        this.authorizeEndpoint = authorizeEndpoint;
    }

    public OAuth2Settings clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The OAuth 2.0 client identifier")
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuth2Settings clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The OAuth 2.0 client secret")
    @JsonProperty(value="clientSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="clientSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuth2Settings scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public OAuth2Settings addscopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of OAuth 2.0 scopes")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public OAuth2Settings tokenEndpoint(URI tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The URL to the authorization server's token endpoint")
    @JsonProperty(value="tokenEndpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @JsonProperty(value="tokenEndpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTokenEndpoint(URI tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Settings oauth2Settings = (OAuth2Settings)o;
        return Objects.equals(this.authorizeEndpoint, oauth2Settings.authorizeEndpoint) && Objects.equals(this.clientId, oauth2Settings.clientId) && Objects.equals(this.clientSecret, oauth2Settings.clientSecret) && Objects.equals(this.scopes, oauth2Settings.scopes) && Objects.equals(this.tokenEndpoint, oauth2Settings.tokenEndpoint);
    }

    public int hashCode() {
        return Objects.hash(this.authorizeEndpoint, this.clientId, this.clientSecret, this.scopes, this.tokenEndpoint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2Settings {\n");
        sb.append("    authorizeEndpoint: ").append(this.toIndentedString(this.authorizeEndpoint)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    tokenEndpoint: ").append(this.toIndentedString(this.tokenEndpoint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

