/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.InlineHookChannelConfigHeaders;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"authScheme", "hookKeyId", "method", "authType", "clientId", "scope", "tokenUrl", "headers", "uri"})
public class InlineHookOAuthPrivateKeyJwtConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTH_SCHEME = "authScheme";
    private JsonNullable<String> authScheme = JsonNullable.undefined();
    public static final String JSON_PROPERTY_HOOK_KEY_ID = "hookKeyId";
    private String hookKeyId;
    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;
    public static final String JSON_PROPERTY_AUTH_TYPE = "authType";
    private String authType;
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;
    public static final String JSON_PROPERTY_TOKEN_URL = "tokenUrl";
    private String tokenUrl;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    private List<InlineHookChannelConfigHeaders> headers = null;
    public static final String JSON_PROPERTY_URI = "uri";
    private String uri;

    public InlineHookOAuthPrivateKeyJwtConfig authScheme(String authScheme) {
        this.authScheme = JsonNullable.of((Object)authScheme);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Not applicable. Must be `null`.")
    @JsonIgnore
    public String getAuthScheme() {
        return (String)this.authScheme.orElse(null);
    }

    @JsonProperty(value="authScheme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAuthScheme_JsonNullable() {
        return this.authScheme;
    }

    @JsonProperty(value="authScheme")
    public void setAuthScheme_JsonNullable(JsonNullable<String> authScheme) {
        this.authScheme = authScheme;
    }

    public void setAuthScheme(String authScheme) {
        this.authScheme = JsonNullable.of((Object)authScheme);
    }

    public InlineHookOAuthPrivateKeyJwtConfig hookKeyId(String hookKeyId) {
        this.hookKeyId = hookKeyId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An ID value of the hook key pair generated from the [Hook Keys API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/HookKey/#tag/HookKey)")
    @JsonProperty(value="hookKeyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHookKeyId() {
        return this.hookKeyId;
    }

    @JsonProperty(value="hookKeyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHookKeyId(String hookKeyId) {
        this.hookKeyId = hookKeyId;
    }

    public InlineHookOAuthPrivateKeyJwtConfig method(String method) {
        this.method = method;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The method of the Okta inline hook request. Only accepts `POST`.")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(String method) {
        this.method = method;
    }

    public InlineHookOAuthPrivateKeyJwtConfig authType(String authType) {
        this.authType = authType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="authType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthType() {
        return this.authType;
    }

    @JsonProperty(value="authType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public InlineHookOAuthPrivateKeyJwtConfig clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A publicly exposed string provided by the service that's used to identify the OAuth app and build authorization URLs")
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public InlineHookOAuthPrivateKeyJwtConfig scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Include the scopes that allow you to perform the actions on the hook endpoint that you want to access")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScope(String scope) {
        this.scope = scope;
    }

    public InlineHookOAuthPrivateKeyJwtConfig tokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URI where inline hooks can exchange an authorization code for access and refresh tokens")
    @JsonProperty(value="tokenUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @JsonProperty(value="tokenUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public InlineHookOAuthPrivateKeyJwtConfig headers(List<InlineHookChannelConfigHeaders> headers) {
        this.headers = headers;
        return this;
    }

    public InlineHookOAuthPrivateKeyJwtConfig addheadersItem(InlineHookChannelConfigHeaders headersItem) {
        if (this.headers == null) {
            this.headers = new ArrayList<InlineHookChannelConfigHeaders>();
        }
        this.headers.add(headersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional list of key/value pairs for headers that you can send with the request to the external service")
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<InlineHookChannelConfigHeaders> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaders(List<InlineHookChannelConfigHeaders> headers) {
        this.headers = headers;
    }

    public InlineHookOAuthPrivateKeyJwtConfig uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The external service endpoint that executes the inline hook handler. It must begin with `https://` and be reachable by Okta. No white space is allowed in the URI.")
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineHookOAuthPrivateKeyJwtConfig inlineHookOAuthPrivateKeyJwtConfig = (InlineHookOAuthPrivateKeyJwtConfig)o;
        return InlineHookOAuthPrivateKeyJwtConfig.equalsNullable(this.authScheme, inlineHookOAuthPrivateKeyJwtConfig.authScheme) && Objects.equals(this.hookKeyId, inlineHookOAuthPrivateKeyJwtConfig.hookKeyId) && Objects.equals(this.method, inlineHookOAuthPrivateKeyJwtConfig.method) && Objects.equals(this.authType, inlineHookOAuthPrivateKeyJwtConfig.authType) && Objects.equals(this.clientId, inlineHookOAuthPrivateKeyJwtConfig.clientId) && Objects.equals(this.scope, inlineHookOAuthPrivateKeyJwtConfig.scope) && Objects.equals(this.tokenUrl, inlineHookOAuthPrivateKeyJwtConfig.tokenUrl) && Objects.equals(this.headers, inlineHookOAuthPrivateKeyJwtConfig.headers) && Objects.equals(this.uri, inlineHookOAuthPrivateKeyJwtConfig.uri);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(InlineHookOAuthPrivateKeyJwtConfig.hashCodeNullable(this.authScheme), this.hookKeyId, this.method, this.authType, this.clientId, this.scope, this.tokenUrl, this.headers, this.uri);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InlineHookOAuthPrivateKeyJwtConfig {\n");
        sb.append("    authScheme: ").append(this.toIndentedString(this.authScheme)).append("\n");
        sb.append("    hookKeyId: ").append(this.toIndentedString(this.hookKeyId)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    authType: ").append(this.toIndentedString(this.authType)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    tokenUrl: ").append(this.toIndentedString(this.tokenUrl)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

