/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdentityAssertionAppInstanceConnectionCreatableApp;
import com.okta.sdk.resource.model.ScopeCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Create an identity assertion connection for an app instance")
@JsonPropertyOrder(value={"app", "connectionType", "issuerUrl", "protocolType", "resourceIndicator", "scopeCondition", "scopes"})
public class IdentityAssertionAppInstanceConnectionCreatable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APP = "app";
    private IdentityAssertionAppInstanceConnectionCreatableApp app;
    public static final String JSON_PROPERTY_CONNECTION_TYPE = "connectionType";
    private ConnectionTypeEnum connectionType;
    public static final String JSON_PROPERTY_ISSUER_URL = "issuerUrl";
    private String issuerUrl;
    public static final String JSON_PROPERTY_PROTOCOL_TYPE = "protocolType";
    private ProtocolTypeEnum protocolType;
    public static final String JSON_PROPERTY_RESOURCE_INDICATOR = "resourceIndicator";
    private URI resourceIndicator;
    public static final String JSON_PROPERTY_SCOPE_CONDITION = "scopeCondition";
    private ScopeCondition scopeCondition;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = new ArrayList<String>();

    public IdentityAssertionAppInstanceConnectionCreatable app(IdentityAssertionAppInstanceConnectionCreatableApp app) {
        this.app = app;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="app")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IdentityAssertionAppInstanceConnectionCreatableApp getApp() {
        return this.app;
    }

    @JsonProperty(value="app")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApp(IdentityAssertionAppInstanceConnectionCreatableApp app) {
        this.app = app;
    }

    public IdentityAssertionAppInstanceConnectionCreatable connectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Type of connection authentication method")
    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConnectionTypeEnum getConnectionType() {
        return this.connectionType;
    }

    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
    }

    public IdentityAssertionAppInstanceConnectionCreatable issuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Issuer URL for the app instance's authorization server")
    @JsonProperty(value="issuerUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    @JsonProperty(value="issuerUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIssuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
    }

    public IdentityAssertionAppInstanceConnectionCreatable protocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authentication protocol type used for the connection")
    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolTypeEnum getProtocolType() {
        return this.protocolType;
    }

    @JsonProperty(value="protocolType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProtocolType(ProtocolTypeEnum protocolType) {
        this.protocolType = protocolType;
    }

    public IdentityAssertionAppInstanceConnectionCreatable resourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resource indicator used when requesting tokens. Defaults to the app instance's ORN if not specified.")
    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getResourceIndicator() {
        return this.resourceIndicator;
    }

    @JsonProperty(value="resourceIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceIndicator(URI resourceIndicator) {
        this.resourceIndicator = resourceIndicator;
    }

    public IdentityAssertionAppInstanceConnectionCreatable scopeCondition(ScopeCondition scopeCondition) {
        this.scopeCondition = scopeCondition;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="scopeCondition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ScopeCondition getScopeCondition() {
        return this.scopeCondition;
    }

    @JsonProperty(value="scopeCondition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScopeCondition(ScopeCondition scopeCondition) {
        this.scopeCondition = scopeCondition;
    }

    public IdentityAssertionAppInstanceConnectionCreatable scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public IdentityAssertionAppInstanceConnectionCreatable addscopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Array of scopes. Required for all `scopeCondition` values. For `ALL_SCOPES`, this array is required with a single value of `*`. For `INCLUDE_ONLY`, only these scopes are allowed. For `EXCLUDE`, all scopes except these are allowed.")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityAssertionAppInstanceConnectionCreatable identityAssertionAppInstanceConnectionCreatable = (IdentityAssertionAppInstanceConnectionCreatable)o;
        return Objects.equals(this.app, identityAssertionAppInstanceConnectionCreatable.app) && Objects.equals((Object)this.connectionType, (Object)identityAssertionAppInstanceConnectionCreatable.connectionType) && Objects.equals(this.issuerUrl, identityAssertionAppInstanceConnectionCreatable.issuerUrl) && Objects.equals((Object)this.protocolType, (Object)identityAssertionAppInstanceConnectionCreatable.protocolType) && Objects.equals(this.resourceIndicator, identityAssertionAppInstanceConnectionCreatable.resourceIndicator) && Objects.equals((Object)this.scopeCondition, (Object)identityAssertionAppInstanceConnectionCreatable.scopeCondition) && Objects.equals(this.scopes, identityAssertionAppInstanceConnectionCreatable.scopes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.app, this.connectionType, this.issuerUrl, this.protocolType, this.resourceIndicator, this.scopeCondition, this.scopes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityAssertionAppInstanceConnectionCreatable {\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    connectionType: ").append(this.toIndentedString((Object)this.connectionType)).append("\n");
        sb.append("    issuerUrl: ").append(this.toIndentedString(this.issuerUrl)).append("\n");
        sb.append("    protocolType: ").append(this.toIndentedString((Object)this.protocolType)).append("\n");
        sb.append("    resourceIndicator: ").append(this.toIndentedString(this.resourceIndicator)).append("\n");
        sb.append("    scopeCondition: ").append(this.toIndentedString((Object)this.scopeCondition)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ConnectionTypeEnum {
        IDENTITY_ASSERTION_APP_INSTANCE(String.valueOf("IDENTITY_ASSERTION_APP_INSTANCE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ConnectionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConnectionTypeEnum fromValue(String value) {
            for (ConnectionTypeEnum b : ConnectionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum ProtocolTypeEnum {
        IDENTITY_ASSERTION(String.valueOf("IDENTITY_ASSERTION")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private ProtocolTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolTypeEnum fromValue(String value) {
            for (ProtocolTypeEnum b : ProtocolTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

