/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A [JSON Web Key](https://tools.ietf.org/html/rfc7517) for a signature or encryption credential for an IdP")
@JsonPropertyOrder(value={"created", "e", "expiresAt", "kid", "kty", "lastUpdated", "n", "use", "x5c", "x5t#S256"})
public class IdPKeyCredential
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_E = "e";
    private String e;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;
    public static final String JSON_PROPERTY_KTY = "kty";
    private String kty;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_N = "n";
    private String n;
    public static final String JSON_PROPERTY_USE = "use";
    private String use;
    public static final String JSON_PROPERTY_X5C = "x5c";
    private List<String> x5c = null;
    public static final String JSON_PROPERTY_X5T_HASH_S256 = "x5t#S256";
    private String x5tHashS256;

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Nullable
    @ApiModelProperty(example="2016-01-03T18:15:47Z", value="Timestamp when the object was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public IdPKeyCredential e(String e) {
        this.e = e;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="AQAB", value="The exponent value for the RSA public key")
    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getE() {
        return this.e;
    }

    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setE(String e) {
        this.e = e;
    }

    @Nullable
    @ApiModelProperty(example="2016-01-03T18:15:47Z", value="Timestamp when the object expires")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public IdPKeyCredential kid(String kid) {
        this.kid = kid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-key-id", value="Unique identifier for the key")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public IdPKeyCredential kty(String kty) {
        this.kty = kty;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="RSA", value="Identifies the cryptographic algorithm family used with the key")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKty() {
        return this.kty;
    }

    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKty(String kty) {
        this.kty = kty;
    }

    @Nullable
    @ApiModelProperty(example="2016-01-03T18:15:47Z", value="Timestamp when the object was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public IdPKeyCredential n(String n) {
        this.n = n;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="101438407598598116085679865987760095721749307901605456708912786847324207000576780508113360584555007890315805735307890113536927352312915634368993759211767770602174860126854831344273970871509573365292777620005537635317282520456901584213746937262823585533063042033441296629204165064680610660631365266976782082747", value="The modulus value for the RSA public key")
    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getN() {
        return this.n;
    }

    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setN(String n) {
        this.n = n;
    }

    public IdPKeyCredential use(String use) {
        this.use = use;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="sig", value="Intended use of the public key")
    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUse() {
        return this.use;
    }

    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUse(String use) {
        this.use = use;
    }

    public IdPKeyCredential x5c(List<String> x5c) {
        this.x5c = x5c;
        return this;
    }

    public IdPKeyCredential addx5cItem(String x5cItem) {
        if (this.x5c == null) {
            this.x5c = new ArrayList<String>();
        }
        this.x5c.add(x5cItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64-encoded X.509 certificate chain with DER encoding")
    @JsonProperty(value="x5c")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getX5c() {
        return this.x5c;
    }

    @JsonProperty(value="x5c")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setX5c(List<String> x5c) {
        this.x5c = x5c;
    }

    public IdPKeyCredential x5tHashS256(String x5tHashS256) {
        this.x5tHashS256 = x5tHashS256;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="wzPVobIrveR1x-PCbjsFGNV-6zn7Rm9KuOWOG4Rk6jE", value="Base64url-encoded SHA-256 thumbprint of the DER encoding of an X.509 certificate")
    @JsonProperty(value="x5t#S256")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getX5tHashS256() {
        return this.x5tHashS256;
    }

    @JsonProperty(value="x5t#S256")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setX5tHashS256(String x5tHashS256) {
        this.x5tHashS256 = x5tHashS256;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdPKeyCredential idPKeyCredential = (IdPKeyCredential)o;
        return Objects.equals(this.created, idPKeyCredential.created) && Objects.equals(this.e, idPKeyCredential.e) && Objects.equals(this.expiresAt, idPKeyCredential.expiresAt) && Objects.equals(this.kid, idPKeyCredential.kid) && Objects.equals(this.kty, idPKeyCredential.kty) && Objects.equals(this.lastUpdated, idPKeyCredential.lastUpdated) && Objects.equals(this.n, idPKeyCredential.n) && Objects.equals(this.use, idPKeyCredential.use) && Objects.equals(this.x5c, idPKeyCredential.x5c) && Objects.equals(this.x5tHashS256, idPKeyCredential.x5tHashS256);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.e, this.expiresAt, this.kid, this.kty, this.lastUpdated, this.n, this.use, this.x5c, this.x5tHashS256, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdPKeyCredential {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    e: ").append(this.toIndentedString(this.e)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString(this.kty)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    n: ").append(this.toIndentedString(this.n)).append("\n");
        sb.append("    use: ").append(this.toIndentedString(this.use)).append("\n");
        sb.append("    x5c: ").append(this.toIndentedString(this.x5c)).append("\n");
        sb.append("    x5tHashS256: ").append(this.toIndentedString(this.x5tHashS256)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

